/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hwpf.model;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.poi.hwpf.model.ListData;
import org.apache.poi.hwpf.model.ListFormatOverride;
import org.apache.poi.hwpf.model.ListFormatOverrideLevel;
import org.apache.poi.hwpf.model.ListLevel;
import org.apache.poi.hwpf.model.io.HWPFOutputStream;
import org.apache.poi.util.LittleEndian;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;

public class ListTables {
    private static final int LIST_DATA_SIZE = 28;
    private static final int LIST_FORMAT_OVERRIDE_SIZE = 16;
    private static POILogger log = POILogFactory.getLogger(class$org$apache$poi$hwpf$model$ListTables == null ? (class$org$apache$poi$hwpf$model$ListTables = ListTables.class$("org.apache.poi.hwpf.model.ListTables")) : class$org$apache$poi$hwpf$model$ListTables);
    HashMap _listMap = new HashMap();
    ArrayList _overrideList = new ArrayList();
    static /* synthetic */ Class class$org$apache$poi$hwpf$model$ListTables;

    public ListTables() {
    }

    public ListTables(byte[] tableStream, int lstOffset, int lfoOffset) {
        int length = LittleEndian.getShort(tableStream, lstOffset);
        int levelOffset = (lstOffset += 2) + length * 28;
        for (int x = 0; x < length; ++x) {
            ListData lst = new ListData(tableStream, lstOffset);
            this._listMap.put(new Integer(lst.getLsid()), lst);
            lstOffset += 28;
            int num = lst.numLevels();
            for (int y = 0; y < num; ++y) {
                ListLevel lvl = new ListLevel(tableStream, levelOffset);
                lst.setLevel(y, lvl);
                levelOffset += lvl.getSizeInBytes();
            }
        }
        length = LittleEndian.getInt(tableStream, lfoOffset);
        int lfolvlOffset = (lfoOffset += 4) + 16 * length;
        for (int x = 0; x < length; ++x) {
            ListFormatOverride lfo = new ListFormatOverride(tableStream, lfoOffset);
            lfoOffset += 16;
            int num = lfo.numOverrides();
            for (int y = 0; y < num; ++y) {
                while (tableStream[lfolvlOffset] == -1) {
                    ++lfolvlOffset;
                }
                ListFormatOverrideLevel lfolvl = new ListFormatOverrideLevel(tableStream, lfolvlOffset);
                lfo.setOverride(y, lfolvl);
                lfolvlOffset += lfolvl.getSizeInBytes();
            }
            this._overrideList.add(lfo);
        }
    }

    public int addList(ListData lst, ListFormatOverride override) {
        int lsid = lst.getLsid();
        while (this._listMap.get(new Integer(lsid)) != null) {
            lsid = lst.resetListID();
            override.setLsid(lsid);
        }
        this._listMap.put(new Integer(lsid), lst);
        this._overrideList.add(override);
        return lsid;
    }

    public void writeListDataTo(HWPFOutputStream tableStream) throws IOException {
        Integer[] intList = this._listMap.keySet().toArray(new Integer[0]);
        ByteArrayOutputStream levelBuf = new ByteArrayOutputStream();
        byte[] listBuf = new byte[intList.length * 28];
        byte[] shortHolder = new byte[2];
        LittleEndian.putShort(shortHolder, (short)intList.length);
        tableStream.write(shortHolder);
        for (int x = 0; x < intList.length; ++x) {
            ListData lst = (ListData)this._listMap.get(intList[x]);
            tableStream.write(lst.toByteArray());
            ListLevel[] lvls = lst.getLevels();
            for (int y = 0; y < lvls.length; ++y) {
                levelBuf.write(lvls[y].toByteArray());
            }
        }
        tableStream.write(levelBuf.toByteArray());
    }

    public void writeListOverridesTo(HWPFOutputStream tableStream) throws IOException {
        ByteArrayOutputStream levelBuf = new ByteArrayOutputStream();
        int size = this._overrideList.size();
        byte[] intHolder = new byte[4];
        LittleEndian.putInt(intHolder, size);
        tableStream.write(intHolder);
        for (int x = 0; x < size; ++x) {
            ListFormatOverride lfo = (ListFormatOverride)this._overrideList.get(x);
            tableStream.write(lfo.toByteArray());
            ListFormatOverrideLevel[] lfolvls = lfo.getLevelOverrides();
            for (int y = 0; y < lfolvls.length; ++y) {
                levelBuf.write(lfolvls[y].toByteArray());
            }
        }
        tableStream.write(levelBuf.toByteArray());
    }

    public ListFormatOverride getOverride(int lfoIndex) {
        return (ListFormatOverride)this._overrideList.get(lfoIndex - 1);
    }

    public int getOverrideIndexFromListID(int lstid) {
        int returnVal = -1;
        int size = this._overrideList.size();
        for (int x = 0; x < size; ++x) {
            ListFormatOverride next = (ListFormatOverride)this._overrideList.get(x);
            if (next.getLsid() != lstid) continue;
            returnVal = x + 1;
            break;
        }
        if (returnVal == -1) {
            throw new NoSuchElementException("No list found with the specified ID");
        }
        return returnVal;
    }

    public ListLevel getLevel(int listID, int level) {
        ListData lst = (ListData)this._listMap.get(new Integer(listID));
        if (level < lst.numLevels()) {
            ListLevel lvl = lst.getLevels()[level];
            return lvl;
        }
        log.log(5, "Requested level " + level + " which was greater than the maximum defined (" + lst.numLevels() + ")");
        return null;
    }

    public ListData getListData(int listID) {
        return (ListData)this._listMap.get(new Integer(listID));
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        ListTables tables = (ListTables)obj;
        if (this._listMap.size() == tables._listMap.size()) {
            Iterator it = this._listMap.keySet().iterator();
            while (it.hasNext()) {
                ListData lst2;
                Object key = it.next();
                ListData lst1 = (ListData)this._listMap.get(key);
                if (lst1.equals(lst2 = (ListData)tables._listMap.get(key))) continue;
                return false;
            }
            int size = this._overrideList.size();
            if (size == tables._overrideList.size()) {
                for (int x = 0; x < size; ++x) {
                    if (this._overrideList.get(x).equals(tables._overrideList.get(x))) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

