/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import org.apache.jackrabbit.core.query.lucene.DefaultHighlighter;
import org.apache.lucene.index.TermPositionVector;
import org.apache.lucene.index.TermVectorOffsetInfo;
import org.apache.lucene.util.PriorityQueue;

public class WeightedHighlighter
extends DefaultHighlighter {
    private static final BitSet PUNCTUATION = new BitSet();

    protected WeightedHighlighter() {
    }

    public static String highlight(TermPositionVector tvec, Set queryTerms, String text, String excerptStart, String excerptEnd, String fragmentStart, String fragmentEnd, String hlStart, String hlEnd, int maxFragments, int surround) throws IOException {
        return new WeightedHighlighter().doHighlight(tvec, queryTerms, text, excerptStart, excerptEnd, fragmentStart, fragmentEnd, hlStart, hlEnd, maxFragments, surround);
    }

    public static String highlight(TermPositionVector tvec, Set queryTerms, String text, int maxFragments, int surround) throws IOException {
        return WeightedHighlighter.highlight(tvec, queryTerms, text, "<excerpt>", "</excerpt>", "<fragment>", "</fragment>", "<highlight>", "</highlight>", maxFragments, surround);
    }

    protected String mergeFragments(TermVectorOffsetInfo[] offsets, String text, String excerptStart, String excerptEnd, String fragmentStart, String fragmentEnd, String hlStart, String hlEnd, int maxFragments, int surround) throws IOException {
        FragmentInfo fi;
        if (offsets == null || offsets.length == 0) {
            return this.createDefaultExcerpt(text, excerptStart, excerptEnd, fragmentStart, fragmentEnd, surround * 2);
        }
        FragmentInfoPriorityQueue bestFragments = new FragmentInfoPriorityQueue(maxFragments);
        for (int i = 0; i < offsets.length; ++i) {
            if (offsets[i].getEndOffset() > text.length()) continue;
            fi = new FragmentInfo(offsets[i], surround * 2);
            for (int j = i + 1; j < offsets.length && offsets[j].getEndOffset() <= text.length() && fi.add(offsets[j], text); ++j) {
            }
            bestFragments.insert(fi);
        }
        if (bestFragments.size() == 0) {
            return this.createDefaultExcerpt(text, excerptStart, excerptEnd, fragmentStart, fragmentEnd, surround * 2);
        }
        LinkedList<FragmentInfo> infos = new LinkedList<FragmentInfo>();
        while (bestFragments.size() > 0) {
            fi = (FragmentInfo)bestFragments.pop();
            infos.add(0, fi);
        }
        IdentityHashMap offsetInfos = new IdentityHashMap();
        Iterator it = infos.iterator();
        while (it.hasNext()) {
            FragmentInfo fi2 = (FragmentInfo)it.next();
            boolean overlap = false;
            Iterator fit = fi2.iterator();
            while (fit.hasNext() && !overlap) {
                TermVectorOffsetInfo oi = (TermVectorOffsetInfo)fit.next();
                if (!offsetInfos.containsKey(oi)) continue;
                overlap = true;
            }
            if (overlap) {
                it.remove();
                continue;
            }
            Iterator oit = fi2.iterator();
            while (oit.hasNext()) {
                offsetInfos.put(oit.next(), null);
            }
        }
        StringBuffer sb = new StringBuffer(excerptStart);
        it = infos.iterator();
        while (it.hasNext()) {
            FragmentInfo fi3 = (FragmentInfo)it.next();
            sb.append(fragmentStart);
            int limit = Math.max(0, fi3.getStartOffset() / 2 + fi3.getEndOffset() / 2 - surround);
            int len = this.startFragment(sb, text, fi3.getStartOffset(), limit);
            TermVectorOffsetInfo lastOffsetInfo = null;
            Iterator fIt = fi3.iterator();
            while (fIt.hasNext()) {
                TermVectorOffsetInfo oi = (TermVectorOffsetInfo)fIt.next();
                if (lastOffsetInfo != null) {
                    sb.append(this.escape(text.substring(lastOffsetInfo.getEndOffset(), oi.getStartOffset())));
                }
                sb.append(hlStart);
                sb.append(this.escape(text.substring(oi.getStartOffset(), oi.getEndOffset())));
                sb.append(hlEnd);
                lastOffsetInfo = oi;
            }
            limit = Math.min(text.length(), fi3.getStartOffset() - len + surround * 2);
            this.endFragment(sb, text, fi3.getEndOffset(), limit);
            sb.append(fragmentEnd);
        }
        sb.append(excerptEnd);
        return sb.toString();
    }

    private int startFragment(StringBuffer sb, String text, int offset, int limit) {
        if (limit == 0) {
            sb.append(this.escape(text.substring(0, offset)));
            return offset;
        }
        String intro = "... ";
        int start = offset;
        for (int i = offset - 1; i >= limit; --i) {
            if (!Character.isWhitespace(text.charAt(i))) continue;
            start = i + 1;
            if (i - 1 < limit || !PUNCTUATION.get(text.charAt(i - 1))) continue;
            intro = "";
            break;
        }
        sb.append(intro).append(this.escape(text.substring(start, offset)));
        return offset - start;
    }

    private void endFragment(StringBuffer sb, String text, int offset, int limit) {
        int end;
        if (limit == text.length()) {
            sb.append(this.escape(text.substring(offset)));
            return;
        }
        for (int i = end = offset; i < limit; ++i) {
            if (!Character.isWhitespace(text.charAt(i))) continue;
            end = i;
        }
        sb.append(this.escape(text.substring(offset, end))).append(" ...");
    }

    static {
        PUNCTUATION.set(46);
        PUNCTUATION.set(33);
        PUNCTUATION.set(161);
        PUNCTUATION.set(63);
        PUNCTUATION.set(191);
    }

    private static class FragmentInfoPriorityQueue
    extends PriorityQueue {
        public FragmentInfoPriorityQueue(int size) {
            this.initialize(size);
        }

        protected boolean lessThan(Object a, Object b) {
            FragmentInfo infoA = (FragmentInfo)a;
            FragmentInfo infoB = (FragmentInfo)b;
            if (infoA.getQuality() == infoB.getQuality()) {
                return infoA.getStartOffset() > infoB.getStartOffset();
            }
            return infoA.getQuality() < infoB.getQuality();
        }
    }

    private static class FragmentInfo {
        ArrayList offsetInfosList = new ArrayList();
        int startOffset;
        int endOffset;
        int maxFragmentSize;
        int quality;

        public FragmentInfo(TermVectorOffsetInfo offsetinfo, int maxFragmentSize) {
            this.offsetInfosList.add(offsetinfo);
            this.startOffset = offsetinfo.getStartOffset();
            this.endOffset = offsetinfo.getEndOffset();
            this.maxFragmentSize = maxFragmentSize;
            this.quality = 0;
        }

        public boolean add(TermVectorOffsetInfo offsetinfo, String text) {
            if (offsetinfo.getEndOffset() > this.startOffset + this.maxFragmentSize) {
                return false;
            }
            this.offsetInfosList.add(offsetinfo);
            if (offsetinfo.getStartOffset() - this.endOffset <= 3) {
                boolean boost = true;
                for (int i = this.endOffset; i < offsetinfo.getStartOffset(); ++i) {
                    if (Character.isWhitespace(text.charAt(i))) continue;
                    boost = false;
                    break;
                }
                this.quality = boost ? (this.quality += 10) : ++this.quality;
            } else {
                ++this.quality;
            }
            this.endOffset = offsetinfo.getEndOffset();
            return true;
        }

        public Iterator iterator() {
            return this.offsetInfosList.iterator();
        }

        public int getStartOffset() {
            return this.startOffset;
        }

        public int getEndOffset() {
            return this.endOffset;
        }

        public int getQuality() {
            return this.quality;
        }
    }
}

