/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.extractor;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import org.apache.jackrabbit.extractor.AbstractTextExtractor;
import org.apache.poi.hwpf.extractor.WordExtractor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MsWordTextExtractor
extends AbstractTextExtractor {
    private static final Logger logger = LoggerFactory.getLogger(MsWordTextExtractor.class);

    public MsWordTextExtractor() {
        super(new String[]{"application/vnd.ms-word", "application/msword"});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Reader extractText(InputStream stream, String type, String encoding) throws IOException {
        try {
            StringReader stringReader = new StringReader(new WordExtractor(stream).getText());
            return stringReader;
        }
        catch (Exception e) {
            logger.warn("Failed to extract Word text content", e);
            StringReader stringReader = new StringReader("");
            return stringReader;
        }
        finally {
            stream.close();
        }
    }

    static {
        WordExtractor.class.getName();
    }
}

