/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vfs.ext.ds;

import java.io.IOException;
import org.apache.commons.io.input.AutoCloseInputStream;
import org.apache.commons.vfs2.FileNotFoundException;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;

public class LazyFileContentInputStream
extends AutoCloseInputStream {
    protected final FileObject fileObject;
    protected boolean opened;

    public LazyFileContentInputStream(FileObject fileObject) throws FileSystemException {
        super(null);
        if (!fileObject.isReadable()) {
            throw new FileNotFoundException((Object)fileObject.getName().getFriendlyURI());
        }
        this.fileObject = fileObject;
    }

    protected void open() throws IOException {
        if (!this.opened) {
            this.opened = true;
            this.in = this.fileObject.getContent().getInputStream();
        }
    }

    public int read() throws IOException {
        this.open();
        return super.read();
    }

    public int available() throws IOException {
        this.open();
        return super.available();
    }

    public void close() throws IOException {
        this.opened = true;
        if (this.in != null) {
            super.close();
        }
    }

    public synchronized void reset() throws IOException {
        this.open();
        super.reset();
    }

    public boolean markSupported() {
        try {
            this.open();
        }
        catch (IOException e) {
            throw new IllegalStateException(e.toString());
        }
        return super.markSupported();
    }

    public synchronized void mark(int readlimit) {
        try {
            this.open();
        }
        catch (IOException e) {
            throw new IllegalStateException(e.toString());
        }
        super.mark(readlimit);
    }

    public long skip(long n) throws IOException {
        this.open();
        return super.skip(n);
    }

    public int read(byte[] b) throws IOException {
        this.open();
        return super.read(b, 0, b.length);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        this.open();
        return super.read(b, off, len);
    }
}

