/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vfs.ext.ds;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Timestamp;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.commons.io.IOUtils;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.apache.jackrabbit.core.data.AbstractBackend;
import org.apache.jackrabbit.core.data.AsyncTouchCallback;
import org.apache.jackrabbit.core.data.AsyncTouchResult;
import org.apache.jackrabbit.core.data.AsyncUploadCallback;
import org.apache.jackrabbit.core.data.AsyncUploadResult;
import org.apache.jackrabbit.core.data.CachingDataStore;
import org.apache.jackrabbit.core.data.DataIdentifier;
import org.apache.jackrabbit.core.data.DataStoreException;
import org.apache.jackrabbit.vfs.ext.ds.LazyFileContentInputStream;
import org.apache.jackrabbit.vfs.ext.ds.VFSUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VFSBackend
extends AbstractBackend {
    private static final Logger LOG = LoggerFactory.getLogger(VFSBackend.class);
    static final int DEFAULT_ASYNC_WRITE_POOL_SIZE = 10;
    private static final int ACCESS_TIME_RESOLUTION = 2000;
    private static final String TOUCH_FILE_NAME_SUFFIX = ".touch";
    private FileObject baseFolder;
    private boolean touchFilePreferred = true;

    public VFSBackend(FileObject baseFolder) {
        this.baseFolder = baseFolder;
    }

    public void init(CachingDataStore store, String homeDir, String config) throws DataStoreException {
        super.init(store, homeDir, config);
        if ("file".equals(this.baseFolder.getName().getScheme())) {
            this.touchFilePreferred = false;
        }
    }

    public InputStream read(DataIdentifier identifier) throws DataStoreException {
        FileObject fileObject = this.getExistingFileObject(identifier);
        if (fileObject == null) {
            throw new DataStoreException("Could not find file object for: " + identifier);
        }
        try {
            return new LazyFileContentInputStream(fileObject);
        }
        catch (FileSystemException e) {
            throw new DataStoreException("Could not get input stream from object: " + identifier, (Throwable)e);
        }
    }

    public long getLength(DataIdentifier identifier) throws DataStoreException {
        FileObject fileObject = this.getExistingFileObject(identifier);
        if (fileObject == null) {
            throw new DataStoreException("Could not find file object for: " + identifier);
        }
        try {
            return fileObject.getContent().getSize();
        }
        catch (FileSystemException e) {
            throw new DataStoreException("Could not get length from object: " + identifier, (Throwable)e);
        }
    }

    public long getLastModified(DataIdentifier identifier) throws DataStoreException {
        FileObject fileObject = this.getExistingFileObject(identifier);
        if (fileObject == null) {
            throw new DataStoreException("Could not find file object for: " + identifier);
        }
        return this.getLastModifiedTime(fileObject);
    }

    public void write(DataIdentifier identifier, File file) throws DataStoreException {
        this.write(identifier, file, false, null);
    }

    public void writeAsync(DataIdentifier identifier, File file, AsyncUploadCallback callback) throws DataStoreException {
        if (callback == null) {
            throw new IllegalArgumentException("callback parameter cannot be null in asyncUpload");
        }
        this.getAsyncWriteExecutor().execute(new AsyncUploadJob(identifier, file, callback));
    }

    public Iterator<DataIdentifier> getAllIdentifiers() throws DataStoreException {
        LinkedList<DataIdentifier> identifiers = new LinkedList<DataIdentifier>();
        try {
            for (FileObject fileObject : VFSUtils.getChildFolders(this.getBaseFolderObject())) {
                this.pushIdentifiersRecursively(identifiers, fileObject);
            }
        }
        catch (FileSystemException e) {
            throw new DataStoreException("Object identifiers not resolved.", (Throwable)e);
        }
        LOG.debug("Found " + identifiers.size() + " identifiers.");
        return identifiers.iterator();
    }

    public boolean exists(DataIdentifier identifier, boolean touch) throws DataStoreException {
        FileObject fileObject = this.getExistingFileObject(identifier);
        if (fileObject == null) {
            return false;
        }
        if (touch) {
            this.touch(identifier, System.currentTimeMillis(), false, null);
        }
        return true;
    }

    public boolean exists(DataIdentifier identifier) throws DataStoreException {
        return this.exists(identifier, false);
    }

    public void touch(DataIdentifier identifier, long minModifiedDate) throws DataStoreException {
        this.touch(identifier, minModifiedDate, false, null);
    }

    public void touchAsync(DataIdentifier identifier, long minModifiedDate, AsyncTouchCallback callback) throws DataStoreException {
        if (callback == null) {
            throw new IllegalArgumentException("callback parameter cannot be null in touchAsync");
        }
        this.getAsyncWriteExecutor().execute(new AsyncTouchJob(identifier, minModifiedDate, callback));
    }

    public Set<DataIdentifier> deleteAllOlderThan(long timestamp) throws DataStoreException {
        HashSet<DataIdentifier> deleteIdSet = new HashSet<DataIdentifier>(30);
        try {
            for (FileObject folderObject : VFSUtils.getChildFolders(this.getBaseFolderObject())) {
                this.deleteOlderRecursive(deleteIdSet, folderObject, timestamp);
            }
        }
        catch (FileSystemException e) {
            throw new DataStoreException("Object deletion aborted.", (Throwable)e);
        }
        return deleteIdSet;
    }

    public void deleteRecord(DataIdentifier identifier) throws DataStoreException {
        FileObject fileObject = this.getExistingFileObject(identifier);
        if (fileObject != null) {
            this.deleteRecordFileObject(fileObject);
            this.deleteEmptyParentFolders(fileObject);
        }
    }

    public boolean isTouchFilePreferred() {
        return this.touchFilePreferred;
    }

    public void setTouchFilePreferred(boolean touchFilePreferred) {
        this.touchFilePreferred = touchFilePreferred;
    }

    protected FileObject getBaseFolderObject() {
        return this.baseFolder;
    }

    protected FileObject resolveFileObject(DataIdentifier identifier) throws DataStoreException {
        try {
            String relPath = this.resolveFileObjectRelPath(identifier);
            return this.getBaseFolderObject().resolveFile(relPath);
        }
        catch (FileSystemException e) {
            throw new DataStoreException("File object not resolved: " + identifier, (Throwable)e);
        }
    }

    protected String resolveFileObjectRelPath(DataIdentifier identifier) {
        String idString = identifier.toString();
        StringBuilder sb = new StringBuilder(80);
        sb.append(idString.substring(0, 2)).append('/');
        sb.append(idString.substring(2, 4)).append('/');
        sb.append(idString.substring(4, 6)).append('/');
        sb.append(idString);
        return sb.toString();
    }

    protected FileObject getExistingFileObject(DataIdentifier identifier) throws DataStoreException {
        String relPath = this.resolveFileObjectRelPath(identifier);
        String[] segments = relPath.split("/");
        FileObject tempFileObject = this.getBaseFolderObject();
        try {
            for (int i = 0; i < segments.length; ++i) {
                if ((tempFileObject = tempFileObject.getChild(segments[i])) != null) continue;
                return null;
            }
            return tempFileObject;
        }
        catch (FileSystemException e) {
            throw new DataStoreException("File object not resolved: " + identifier, (Throwable)e);
        }
    }

    protected boolean isTouchFileObject(FileObject fileObject) {
        return fileObject.getName().getBaseName().endsWith(TOUCH_FILE_NAME_SUFFIX);
    }

    protected FileObject getTouchFileObject(FileObject fileObject, boolean create) throws DataStoreException {
        try {
            FileObject folderObject = fileObject.getParent();
            String touchFileName = fileObject.getName().getBaseName() + TOUCH_FILE_NAME_SUFFIX;
            FileObject touchFileObject = folderObject.getChild(touchFileName);
            if (touchFileObject == null && create) {
                touchFileObject = folderObject.resolveFile(touchFileName);
                touchFileObject.createFile();
                touchFileObject = folderObject.getChild(touchFileName);
            }
            return touchFileObject;
        }
        catch (FileSystemException e) {
            throw new DataStoreException("Touch file object not resolved: " + fileObject.getName().getFriendlyURI(), (Throwable)e);
        }
    }

    protected int getAsyncWriteExecutorActiveCount() {
        Executor asyncExecutor = this.getAsyncWriteExecutor();
        if (asyncExecutor != null && asyncExecutor instanceof ThreadPoolExecutor) {
            return ((ThreadPoolExecutor)asyncExecutor).getActiveCount();
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyFileContentToRecord(File srcFile, DataIdentifier identifier) throws IOException, DataStoreException {
        String relPath = this.resolveFileObjectRelPath(identifier);
        String[] segments = relPath.split("/");
        FileInputStream input = null;
        OutputStream output = null;
        try {
            FileObject baseFolderObject = this.getBaseFolderObject();
            FileObject folderObject = null;
            for (int i = 0; i < segments.length - 1; ++i) {
                baseFolderObject = folderObject = VFSUtils.createChildFolder(baseFolderObject, segments[i]);
            }
            FileObject destFileObject = VFSUtils.createChildFile(folderObject, segments[segments.length - 1]);
            input = new FileInputStream(srcFile);
            output = destFileObject.getContent().getOutputStream();
            IOUtils.copy((InputStream)input, (OutputStream)output);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(output);
            IOUtils.closeQuietly(input);
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)output);
        IOUtils.closeQuietly((InputStream)input);
    }

    private void updateLastModifiedTime(FileObject fileObject) throws DataStoreException {
        try {
            if (this.isTouchFilePreferred()) {
                this.getTouchFileObject(fileObject, true);
            } else {
                long time = System.currentTimeMillis() + 2000L;
                fileObject.getContent().setLastModifiedTime(time);
            }
        }
        catch (FileSystemException e) {
            throw new DataStoreException("An IO Exception occurred while trying to set the last modified date: " + fileObject.getName().getFriendlyURI(), (Throwable)e);
        }
    }

    private long getLastModifiedTime(FileObject fileObject) throws DataStoreException {
        long lastModified = 0L;
        try {
            FileObject touchFile;
            lastModified = this.isTouchFilePreferred() ? ((touchFile = this.getTouchFileObject(fileObject, false)) != null ? touchFile.getContent().getLastModifiedTime() : fileObject.getContent().getLastModifiedTime()) : fileObject.getContent().getLastModifiedTime();
            if (lastModified == 0L) {
                throw new DataStoreException("Failed to read record modified date: " + fileObject.getName().getFriendlyURI());
            }
        }
        catch (FileSystemException e) {
            throw new DataStoreException("Failed to read record modified date: " + fileObject.getName().getFriendlyURI());
        }
        return lastModified;
    }

    private void pushIdentifiersRecursively(List<DataIdentifier> identifiers, FileObject folderObject) throws FileSystemException, DataStoreException {
        for (FileObject fileObject : VFSUtils.getChildFileOrFolders(folderObject)) {
            FileType type = fileObject.getType();
            if (type == FileType.FOLDER) {
                this.pushIdentifiersRecursively(identifiers, fileObject);
                continue;
            }
            if (type != FileType.FILE || this.isTouchFileObject(fileObject)) continue;
            identifiers.add(new DataIdentifier(fileObject.getName().getBaseName()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(DataIdentifier identifier, File file, boolean asyncUpload, AsyncUploadCallback callback) throws DataStoreException {
        AsyncUploadResult asyncUpRes = null;
        if (asyncUpload) {
            asyncUpRes = new AsyncUploadResult(identifier, file);
        }
        VFSBackend vFSBackend = this;
        synchronized (vFSBackend) {
            FileObject fileObject = this.getExistingFileObject(identifier);
            FileObject resolvedFileObject = this.resolveFileObject(identifier);
            try {
                if (fileObject != null) {
                    this.updateLastModifiedTime(resolvedFileObject);
                } else {
                    this.copyFileContentToRecord(file, identifier);
                }
                if (asyncUpRes != null && callback != null) {
                    callback.onSuccess(asyncUpRes);
                }
            }
            catch (IOException e) {
                DataStoreException e2 = new DataStoreException("Could not get output stream to object: " + resolvedFileObject.getName().getFriendlyURI(), (Throwable)e);
                if (asyncUpRes != null && callback != null) {
                    asyncUpRes.setException((Exception)((Object)e2));
                    callback.onFailure(asyncUpRes);
                }
                throw e2;
            }
        }
    }

    private void touch(DataIdentifier identifier, long minModifiedDate, boolean asyncTouch, AsyncTouchCallback callback) throws DataStoreException {
        AsyncTouchResult asyncTouchRes = null;
        if (asyncTouch) {
            asyncTouchRes = new AsyncTouchResult(identifier);
        }
        try {
            FileObject fileObject = this.getExistingFileObject(identifier);
            if (fileObject != null) {
                if (minModifiedDate > 0L && minModifiedDate > this.getLastModifiedTime(fileObject)) {
                    this.updateLastModifiedTime(fileObject);
                }
            } else {
                LOG.debug("File doesn't exist for the identifier: {}.", (Object)identifier);
            }
        }
        catch (DataStoreException e) {
            if (asyncTouchRes != null) {
                asyncTouchRes.setException((Exception)((Object)e));
            }
            throw e;
        }
        finally {
            if (asyncTouchRes != null && callback != null) {
                if (asyncTouchRes.getException() != null) {
                    callback.onFailure(asyncTouchRes);
                } else {
                    callback.onSuccess(asyncTouchRes);
                }
            }
        }
    }

    private boolean deleteRecordFileObject(FileObject fileObject) throws DataStoreException {
        if (this.isTouchFilePreferred()) {
            try {
                FileObject touchFile = this.getTouchFileObject(fileObject, false);
                if (touchFile != null) {
                    touchFile.delete();
                }
            }
            catch (FileSystemException e) {
                LOG.warn("Could not delete touch file for " + fileObject.getName().getFriendlyURI(), (Throwable)e);
            }
        }
        try {
            return fileObject.delete();
        }
        catch (FileSystemException e) {
            throw new DataStoreException("Could not delete record file at " + fileObject.getName().getFriendlyURI(), (Throwable)e);
        }
    }

    private void deleteEmptyParentFolders(FileObject fileObject) throws DataStoreException {
        try {
            String baseFolderUri = this.getBaseFolderObject().getName().getFriendlyURI() + "/";
            FileObject parentFolder = fileObject.getParent();
            while (parentFolder.getName().getFriendlyURI().startsWith(baseFolderUri) && !VFSUtils.hasAnyChildFileOrFolder(parentFolder)) {
                boolean deleted = parentFolder.delete();
                LOG.debug("Deleted parent folder [{}] of file [{}]: {}", new Object[]{parentFolder, fileObject.getName().getFriendlyURI(), deleted});
                parentFolder = parentFolder.getParent();
            }
        }
        catch (IOException e) {
            LOG.warn("Error in parents deletion for " + fileObject.getName().getFriendlyURI(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteOlderRecursive(Set<DataIdentifier> deleteIdSet, FileObject folderObject, long timestamp) throws FileSystemException, DataStoreException {
        for (FileObject fileObject : VFSUtils.getChildFileOrFolders(folderObject)) {
            long lastModified;
            FileType type = fileObject.getType();
            if (type == FileType.FOLDER) {
                this.deleteOlderRecursive(deleteIdSet, fileObject, timestamp);
                VFSBackend vFSBackend = this;
                synchronized (vFSBackend) {
                    if (!VFSUtils.hasAnyChildFileOrFolder(fileObject)) {
                        fileObject.delete();
                    }
                    continue;
                }
            }
            if (type != FileType.FILE || (lastModified = this.getLastModifiedTime(fileObject)) >= timestamp) continue;
            DataIdentifier identifier = new DataIdentifier(fileObject.getName().getBaseName());
            if (!this.getDataStore().confirmDelete(identifier)) continue;
            this.getDataStore().deleteFromCache(identifier);
            if (LOG.isInfoEnabled()) {
                LOG.info("Deleting old file " + fileObject.getName().getFriendlyURI() + " modified: " + new Timestamp(lastModified).toString() + " length: " + fileObject.getContent().getSize());
            }
            if (this.deleteRecordFileObject(fileObject)) {
                deleteIdSet.add(identifier);
                continue;
            }
            LOG.warn("Failed to delete old file " + fileObject.getName().getFriendlyURI());
        }
    }

    private class AsyncTouchJob
    implements Runnable {
        private DataIdentifier identifier;
        private long minModifiedDate;
        private AsyncTouchCallback callback;

        public AsyncTouchJob(DataIdentifier identifier, long minModifiedDate, AsyncTouchCallback callback) {
            this.identifier = identifier;
            this.minModifiedDate = minModifiedDate;
            this.callback = callback;
        }

        @Override
        public void run() {
            try {
                VFSBackend.this.touch(this.identifier, this.minModifiedDate, true, this.callback);
            }
            catch (DataStoreException e) {
                LOG.error("Could not touch [" + this.identifier + "]", (Throwable)e);
            }
        }
    }

    private class AsyncUploadJob
    implements Runnable {
        private DataIdentifier identifier;
        private File file;
        private AsyncUploadCallback callback;

        public AsyncUploadJob(DataIdentifier identifier, File file, AsyncUploadCallback callback) {
            this.identifier = identifier;
            this.file = file;
            this.callback = callback;
        }

        @Override
        public void run() {
            try {
                VFSBackend.this.write(this.identifier, this.file, true, this.callback);
            }
            catch (DataStoreException e) {
                LOG.error("Could not upload [" + this.identifier + "], file[" + this.file + "]", (Throwable)e);
            }
        }
    }
}

