/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vfs.ext.ds;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.apache.jackrabbit.core.data.DataStoreException;

class VFSUtils {
    static Set<FileType> FILE_ONLY_TYPES = Collections.unmodifiableSet(new HashSet<FileType>(Arrays.asList(FileType.FILE)));
    static Set<FileType> FOLDER_ONLY_TYPES = Collections.unmodifiableSet(new HashSet<FileType>(Arrays.asList(FileType.FOLDER)));
    static Set<FileType> FILE_OR_FOLDER_TYPES = Collections.unmodifiableSet(new HashSet<FileType>(Arrays.asList(FileType.FILE, FileType.FOLDER)));

    static FileObject createChildFolder(FileObject baseFolder, String name) throws DataStoreException {
        FileObject childFolder = null;
        try {
            childFolder = baseFolder.resolveFile(name);
            if (!childFolder.exists()) {
                childFolder.createFolder();
                childFolder = baseFolder.getChild(childFolder.getName().getBaseName());
            }
        }
        catch (FileSystemException e) {
            throw new DataStoreException("Could not create a child folder, '" + name + "' under " + baseFolder.getName().getFriendlyURI(), (Throwable)e);
        }
        return childFolder;
    }

    static FileObject createChildFile(FileObject baseFolder, String name) throws DataStoreException {
        FileObject childFile = null;
        try {
            childFile = baseFolder.resolveFile(name);
            if (!childFile.exists()) {
                childFile.createFile();
                childFile = baseFolder.getChild(childFile.getName().getBaseName());
            }
        }
        catch (FileSystemException e) {
            throw new DataStoreException("Could not create a child file, '" + name + "' under " + baseFolder.getName().getFriendlyURI(), (Throwable)e);
        }
        return childFile;
    }

    static List<FileObject> getChildFiles(FileObject folderObject) throws DataStoreException {
        return VFSUtils.getChildrenOfTypes(folderObject, FILE_ONLY_TYPES);
    }

    static List<FileObject> getChildFolders(FileObject folderObject) throws DataStoreException {
        return VFSUtils.getChildrenOfTypes(folderObject, FOLDER_ONLY_TYPES);
    }

    static List<FileObject> getChildFileOrFolders(FileObject folderObject) throws DataStoreException {
        return VFSUtils.getChildrenOfTypes(folderObject, FILE_OR_FOLDER_TYPES);
    }

    static boolean hasAnyChildFileOrFolder(FileObject folderObject) throws DataStoreException {
        return !VFSUtils.getChildFileOrFolders(folderObject).isEmpty();
    }

    private static List<FileObject> getChildrenOfTypes(FileObject folderObject, Set<FileType> fileTypes) throws DataStoreException {
        try {
            String folderBaseName = folderObject.getName().getBaseName();
            FileObject[] children = folderObject.getChildren();
            ArrayList<FileObject> files = new ArrayList<FileObject>(children.length);
            for (int i = 0; i < children.length; ++i) {
                FileType fileType;
                block5: {
                    String childBaseName = children[i].getName().getBaseName();
                    fileType = null;
                    try {
                        fileType = children[i].getType();
                    }
                    catch (FileSystemException notDetermineTypeEx) {
                        if (folderBaseName.equals(childBaseName)) break block5;
                        throw notDetermineTypeEx;
                    }
                }
                if (fileType == null || !fileTypes.contains(fileType)) continue;
                files.add(children[i]);
            }
            return files;
        }
        catch (FileSystemException e) {
            throw new DataStoreException("Could not find children under " + folderObject.getName().getFriendlyURI(), (Throwable)e);
        }
    }

    private VFSUtils() {
    }
}

