/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vfs.ext.fs;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.Properties;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.NameScope;
import org.apache.commons.vfs2.impl.DefaultFileSystemManager;
import org.apache.commons.vfs2.impl.StandardFileSystemManager;
import org.apache.commons.vfs2.util.DelegatingFileSystemOptionsBuilder;
import org.apache.jackrabbit.core.fs.FileSystem;
import org.apache.jackrabbit.vfs.ext.ds.LazyFileContentInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VFSFileSystem
implements FileSystem {
    private static Logger log = LoggerFactory.getLogger(VFSFileSystem.class);
    static final String BASE_FOLDER_URI = "baseFolderUri";
    static final String FILE_SYSTEM_MANAGER_CLASS_NAME = "fileSystemManagerClassName";
    private String config;
    private static final String FILE_SYSTEM_OPTIONS_PROP_PREFIX = "fso.";
    private String fileSystemManagerClassName;
    private FileSystemManager fileSystemManager;
    private FileSystemOptions fileSystemOptions;
    private Properties fileSystemOptionsProperties;
    private String baseFolderUri;
    private FileObject baseFolder;

    public String getConfig() {
        return this.config;
    }

    public void setConfig(String config) {
        this.config = config;
    }

    public String getFileSystemManagerClassName() {
        return this.fileSystemManagerClassName;
    }

    public void setFileSystemManagerClassName(String fileSystemManagerClassName) {
        this.fileSystemManagerClassName = fileSystemManagerClassName;
    }

    public FileSystemManager getFileSystemManager() {
        return this.fileSystemManager;
    }

    public FileSystemOptions getFileSystemOptions() throws org.apache.jackrabbit.core.fs.FileSystemException {
        if (this.fileSystemOptions == null) {
            this.fileSystemOptions = this.createFileSystemOptions();
        }
        return this.fileSystemOptions;
    }

    public void setFileSystemOptions(FileSystemOptions fileSystemOptions) {
        this.fileSystemOptions = fileSystemOptions;
    }

    public void setFileSystemOptionsProperties(Properties fileSystemOptionsProperties) {
        this.fileSystemOptionsProperties = fileSystemOptionsProperties;
    }

    public void setFileSystemOptionsPropertiesInString(String fileSystemOptionsPropertiesInString) {
        if (fileSystemOptionsPropertiesInString != null) {
            try {
                StringReader reader = new StringReader(fileSystemOptionsPropertiesInString);
                Properties props = new Properties();
                props.load(reader);
                this.fileSystemOptionsProperties = props;
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Could not load file system options properties.", e);
            }
        }
    }

    public void setBaseFolderUri(String baseFolderUri) {
        this.baseFolderUri = baseFolderUri;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof VFSFileSystem) {
            VFSFileSystem other = (VFSFileSystem)obj;
            if (this.baseFolder == null) {
                return other.baseFolder == null;
            }
            return this.baseFolder.equals(other.baseFolder);
        }
        return false;
    }

    public int hashCode() {
        return 0;
    }

    public void init() throws org.apache.jackrabbit.core.fs.FileSystemException {
        this.overridePropertiesFromConfig();
        if (this.baseFolderUri == null) {
            throw new org.apache.jackrabbit.core.fs.FileSystemException("VFS base folder URI must be set.");
        }
        this.fileSystemManager = this.createFileSystemManager();
        FileName baseFolderName = null;
        try {
            baseFolderName = this.fileSystemManager.resolveURI(this.baseFolderUri);
            FileSystemOptions fso = this.getFileSystemOptions();
            this.baseFolder = fso != null ? this.fileSystemManager.resolveFile(this.baseFolderUri, fso) : this.fileSystemManager.resolveFile(this.baseFolderUri);
            this.baseFolder.createFolder();
        }
        catch (FileSystemException e) {
            throw new org.apache.jackrabbit.core.fs.FileSystemException("Could not initialize the VFS base folder at '" + (baseFolderName == null ? "" : baseFolderName.getFriendlyURI()) + "'.", (Throwable)e);
        }
        log.info("VFSFileSystem initialized at the base path, {}.", (Object)this.baseFolderUri);
    }

    public void close() throws org.apache.jackrabbit.core.fs.FileSystemException {
        if (this.fileSystemManager instanceof DefaultFileSystemManager) {
            ((DefaultFileSystemManager)this.fileSystemManager).close();
        }
    }

    public void createFolder(String folderPath) throws org.apache.jackrabbit.core.fs.FileSystemException {
        try {
            FileObject fo = this.resolveFileObject(folderPath);
            if (fo.isFolder()) {
                log.debug("Folder already exists at {}.", (Object)fo.getName().getFriendlyURI());
                throw new org.apache.jackrabbit.core.fs.FileSystemException("Folder already exists at " + folderPath + ".");
            }
            fo.createFolder();
        }
        catch (FileSystemException e) {
            String msg = "Failed to create folder at " + folderPath + ".";
            log.debug(msg, (Throwable)e);
            throw new org.apache.jackrabbit.core.fs.FileSystemException(msg, (Throwable)e);
        }
    }

    public void deleteFile(String filePath) throws org.apache.jackrabbit.core.fs.FileSystemException {
        try {
            FileObject fo = this.resolveFileObject(filePath);
            if (!fo.isFile()) {
                throw new org.apache.jackrabbit.core.fs.FileSystemException("File doesn't exist at " + filePath + ".");
            }
            fo.delete();
        }
        catch (FileSystemException e) {
            String msg = "Failed to delete file at " + filePath;
            log.debug(msg, (Throwable)e);
            throw new org.apache.jackrabbit.core.fs.FileSystemException(msg, (Throwable)e);
        }
    }

    public void deleteFolder(String folderPath) throws org.apache.jackrabbit.core.fs.FileSystemException {
        try {
            FileObject fo = this.resolveFileObject(folderPath);
            if (!fo.isFolder()) {
                String msg = "Folder doesn't exist at " + folderPath + ".";
                log.debug(msg);
                throw new org.apache.jackrabbit.core.fs.FileSystemException(msg);
            }
            fo.deleteAll();
        }
        catch (FileSystemException e) {
            String msg = "Failed to delete folder at " + folderPath + ".";
            log.debug(msg, (Throwable)e);
            throw new org.apache.jackrabbit.core.fs.FileSystemException(msg, (Throwable)e);
        }
    }

    public boolean exists(String path) throws org.apache.jackrabbit.core.fs.FileSystemException {
        try {
            FileObject fo = this.resolveFileObject(path);
            return fo.exists();
        }
        catch (FileSystemException e) {
            String msg = "Failed to check if file exists at " + path + ".";
            log.debug(msg, (Throwable)e);
            throw new org.apache.jackrabbit.core.fs.FileSystemException(msg, (Throwable)e);
        }
    }

    public InputStream getInputStream(String filePath) throws org.apache.jackrabbit.core.fs.FileSystemException {
        try {
            FileObject fo = this.resolveFileObject(filePath);
            FileObject folder = fo.getParent();
            if (!folder.exists() || !folder.isFolder()) {
                throw new org.apache.jackrabbit.core.fs.FileSystemException("Folder doesn't exist for " + filePath + ".");
            }
            return new LazyFileContentInputStream(fo);
        }
        catch (FileSystemException e) {
            String msg = "Failed to open an input stream from " + filePath + ".";
            log.debug(msg, (Throwable)e);
            throw new org.apache.jackrabbit.core.fs.FileSystemException(msg, (Throwable)e);
        }
    }

    public OutputStream getOutputStream(String filePath) throws org.apache.jackrabbit.core.fs.FileSystemException {
        try {
            FileObject fo = this.resolveFileObject(filePath);
            FileObject folder = fo.getParent();
            if (!folder.exists() || !folder.isFolder()) {
                throw new org.apache.jackrabbit.core.fs.FileSystemException("Folder doesn't exist for " + filePath + ".");
            }
            return fo.getContent().getOutputStream();
        }
        catch (FileSystemException e) {
            String msg = "Failed to open an output stream to " + filePath + ".";
            log.debug(msg, (Throwable)e);
            throw new org.apache.jackrabbit.core.fs.FileSystemException(msg, (Throwable)e);
        }
    }

    public boolean hasChildren(String path) throws org.apache.jackrabbit.core.fs.FileSystemException {
        try {
            FileObject fo = this.resolveFileObject(path);
            if (!fo.exists()) {
                String msg = "File doesn't exist at " + path + ".";
                log.debug(msg);
                throw new org.apache.jackrabbit.core.fs.FileSystemException(msg);
            }
            if (fo.isFile()) {
                return false;
            }
            return fo.getChildren().length > 0;
        }
        catch (FileSystemException e) {
            String msg = "Failed to check if there's any child at " + path + ".";
            log.debug(msg, (Throwable)e);
            throw new org.apache.jackrabbit.core.fs.FileSystemException(msg, (Throwable)e);
        }
    }

    public boolean isFile(String path) throws org.apache.jackrabbit.core.fs.FileSystemException {
        try {
            FileObject fo = this.resolveFileObject(path);
            return fo.isFile();
        }
        catch (FileSystemException e) {
            String msg = "Failed to check if it is a file at " + path + ".";
            log.debug(msg, (Throwable)e);
            throw new org.apache.jackrabbit.core.fs.FileSystemException(msg, (Throwable)e);
        }
    }

    public boolean isFolder(String path) throws org.apache.jackrabbit.core.fs.FileSystemException {
        try {
            FileObject fo = this.resolveFileObject(path);
            return fo.isFolder();
        }
        catch (FileSystemException e) {
            String msg = "Failed to check if it is a folder at " + path + ".";
            log.debug(msg, (Throwable)e);
            throw new org.apache.jackrabbit.core.fs.FileSystemException(msg, (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long lastModified(String path) throws org.apache.jackrabbit.core.fs.FileSystemException {
        try (FileObject fo = this.resolveFileObject(path);){
            long l = fo.getContent().getLastModifiedTime();
            return l;
        }
        catch (FileSystemException e) {
            String msg = "Failed to get the last modified time of the file at " + path + ".";
            log.debug(msg, (Throwable)e);
            throw new org.apache.jackrabbit.core.fs.FileSystemException(msg, (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long length(String filePath) throws org.apache.jackrabbit.core.fs.FileSystemException {
        try (FileObject fo = this.resolveFileObject(filePath);){
            long l = fo.getContent().getSize();
            return l;
        }
        catch (FileSystemException e) {
            String msg = "Failed to get the length of the file at " + filePath + ".";
            log.debug(msg, (Throwable)e);
            throw new org.apache.jackrabbit.core.fs.FileSystemException(msg, (Throwable)e);
        }
    }

    public String[] list(String folderPath) throws org.apache.jackrabbit.core.fs.FileSystemException {
        try {
            FileObject fo = this.resolveFileObject(folderPath);
            FileObject[] children = fo.getChildren();
            int size = children.length;
            String[] entries = new String[size];
            for (int i = 0; i < size; ++i) {
                entries[i] = children[i].getName().getBaseName();
            }
            return entries;
        }
        catch (FileSystemException e) {
            String msg = "Failed to list children of the folder at " + folderPath + ".";
            log.debug(msg, (Throwable)e);
            throw new org.apache.jackrabbit.core.fs.FileSystemException(msg, (Throwable)e);
        }
    }

    public String[] listFiles(String folderPath) throws org.apache.jackrabbit.core.fs.FileSystemException {
        try {
            FileObject fo = this.resolveFileObject(folderPath);
            LinkedList<String> entries = new LinkedList<String>();
            for (FileObject child : fo.getChildren()) {
                if (!child.isFile()) continue;
                entries.add(child.getName().getBaseName());
            }
            return entries.toArray(new String[entries.size()]);
        }
        catch (FileSystemException e) {
            String msg = "Failed to list child files of the folder at " + folderPath + ".";
            log.debug(msg, (Throwable)e);
            throw new org.apache.jackrabbit.core.fs.FileSystemException(msg, (Throwable)e);
        }
    }

    public String[] listFolders(String folderPath) throws org.apache.jackrabbit.core.fs.FileSystemException {
        try {
            FileObject fo = this.resolveFileObject(folderPath);
            LinkedList<String> entries = new LinkedList<String>();
            for (FileObject child : fo.getChildren()) {
                if (!child.isFolder()) continue;
                entries.add(child.getName().getBaseName());
            }
            return entries.toArray(new String[entries.size()]);
        }
        catch (FileSystemException e) {
            String msg = "Failed to list child folders of the folder at " + folderPath + ".";
            log.debug(msg);
            throw new org.apache.jackrabbit.core.fs.FileSystemException(msg, (Throwable)e);
        }
    }

    protected FileSystemManager createFileSystemManager() throws org.apache.jackrabbit.core.fs.FileSystemException {
        StandardFileSystemManager fileSystemManager = null;
        try {
            if (this.getFileSystemManagerClassName() == null) {
                fileSystemManager = new StandardFileSystemManager();
            } else {
                Class<?> mgrClass = Class.forName(this.getFileSystemManagerClassName());
                fileSystemManager = (FileSystemManager)mgrClass.newInstance();
            }
            if (fileSystemManager instanceof DefaultFileSystemManager) {
                ((DefaultFileSystemManager)fileSystemManager).init();
            }
        }
        catch (Exception e) {
            throw new org.apache.jackrabbit.core.fs.FileSystemException("Could not create file system manager of class: " + this.getFileSystemManagerClassName(), (Throwable)e);
        }
        return fileSystemManager;
    }

    protected FileSystemOptions createFileSystemOptions() throws org.apache.jackrabbit.core.fs.FileSystemException {
        FileSystemOptions fso = null;
        if (this.fileSystemOptionsProperties != null) {
            try {
                fso = new FileSystemOptions();
                DelegatingFileSystemOptionsBuilder delegate = new DelegatingFileSystemOptionsBuilder(this.getFileSystemManager());
                Enumeration<?> e = this.fileSystemOptionsProperties.propertyNames();
                while (e.hasMoreElements()) {
                    String key = (String)e.nextElement();
                    if (!key.startsWith(FILE_SYSTEM_OPTIONS_PROP_PREFIX)) continue;
                    String value = this.fileSystemOptionsProperties.getProperty(key);
                    String schemeDotPropName = key.substring(FILE_SYSTEM_OPTIONS_PROP_PREFIX.length());
                    int offset = schemeDotPropName.indexOf(46);
                    if (offset > 0) {
                        String scheme = schemeDotPropName.substring(0, offset);
                        String propName = schemeDotPropName.substring(offset + 1);
                        delegate.setConfigString(fso, scheme, propName, value);
                        continue;
                    }
                    log.warn("Ignoring an FileSystemOptions property in invalid format. Key: {}, Value: {}", (Object)key, (Object)value);
                }
            }
            catch (FileSystemException e) {
                throw new org.apache.jackrabbit.core.fs.FileSystemException("Could not create File System Options.", (Throwable)e);
            }
        }
        return fso;
    }

    protected Properties getFileSystemOptionsProperties() {
        return this.fileSystemOptionsProperties;
    }

    private void overridePropertiesFromConfig() throws org.apache.jackrabbit.core.fs.FileSystemException {
        String config = this.getConfig();
        if (config != null && !"".equals(config)) {
            try {
                Properties props = this.readConfig(config);
                String propValue = props.getProperty(BASE_FOLDER_URI);
                if (propValue != null && !"".equals(propValue)) {
                    this.setBaseFolderUri(propValue);
                }
                if ((propValue = props.getProperty(FILE_SYSTEM_MANAGER_CLASS_NAME)) != null && !"".equals(propValue)) {
                    this.setFileSystemManagerClassName(propValue);
                }
                Properties fsoProps = new Properties();
                Enumeration<?> propNames = props.propertyNames();
                while (propNames.hasMoreElements()) {
                    String propName = (String)propNames.nextElement();
                    if (!propName.startsWith(FILE_SYSTEM_OPTIONS_PROP_PREFIX)) continue;
                    fsoProps.setProperty(propName, props.getProperty(propName));
                }
                if (!fsoProps.isEmpty()) {
                    this.setFileSystemOptionsProperties(fsoProps);
                }
            }
            catch (IOException e) {
                throw new org.apache.jackrabbit.core.fs.FileSystemException("Configuration file doesn't exist at '" + config + "'.");
            }
        }
    }

    private Properties readConfig(String fileName) throws IOException {
        if (!new File(fileName).exists()) {
            throw new IOException("Config file not found: " + fileName);
        }
        Properties prop = new Properties();
        try (FileInputStream in = new FileInputStream(fileName);){
            prop.load(in);
        }
        return prop;
    }

    private FileObject resolveFileObject(String path) throws org.apache.jackrabbit.core.fs.FileSystemException {
        if (path == null) {
            throw new IllegalArgumentException("path must not be null.");
        }
        String normalizedPath = (path.startsWith("/") ? path.substring(1) : path).trim();
        if (normalizedPath.isEmpty()) {
            return this.baseFolder;
        }
        try {
            return this.baseFolder.resolveFile(normalizedPath, NameScope.DESCENDENT);
        }
        catch (FileSystemException e) {
            throw new org.apache.jackrabbit.core.fs.FileSystemException("Cannot resolve file at " + path + ".", (Throwable)e);
        }
    }
}

