/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.j2ee;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.Properties;
import javax.jcr.Repository;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import org.apache.jackrabbit.j2ee.BootstrapConfig;
import org.apache.jackrabbit.rmi.client.ClientRepositoryFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepositoryAccessServlet
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger((Class)RepositoryAccessServlet.class);
    public static final String INIT_PARAM_BOOTSTRAP_CONFIG = "bootstrap-config";
    private static final String CTX_PARAM_THIS = "repository.access.servlet";
    private BootstrapConfig config;
    private InitialContext jndiContext;
    private String repositoryContextAttributeName;
    private Repository repository;
    static /* synthetic */ Class class$org$apache$jackrabbit$rmi$client$ClientRepositoryFactory;

    public void init() throws ServletException {
        if (this.getServletContext().getAttribute(CTX_PARAM_THIS) != null) {
            throw new ServletException("Only one repository access servlet allowed per web-app.");
        }
        this.getServletContext().setAttribute(CTX_PARAM_THIS, (Object)this);
        this.repositoryContextAttributeName = this.getServletConfig().getInitParameter("repository.context.attribute.name");
        log.info("RepositoryAccessServlet initialized.");
    }

    private static RepositoryAccessServlet getInstance(ServletContext ctx) {
        RepositoryAccessServlet instance = (RepositoryAccessServlet)((Object)ctx.getAttribute(CTX_PARAM_THIS));
        if (instance == null) {
            throw new IllegalStateException("No RepositoryAccessServlet instance in ServletContext, RepositoryAccessServlet servlet not initialized?");
        }
        return instance;
    }

    private BootstrapConfig getConfig() throws ServletException {
        if (this.config == null) {
            Properties bootstrapProps = new Properties();
            String bstrp = this.getServletConfig().getInitParameter(INIT_PARAM_BOOTSTRAP_CONFIG);
            if (bstrp != null) {
                File file;
                InputStream in = this.getServletContext().getResourceAsStream(bstrp);
                if (in == null && (file = new File(bstrp)).canRead()) {
                    try {
                        in = new FileInputStream(file);
                    }
                    catch (FileNotFoundException e) {
                        log.error("Error while opening bootstrap properties: {}", (Object)e.toString());
                        throw new ServletException("Error while opening bootstrap properties: " + e.toString());
                    }
                }
                if (in != null) {
                    try {
                        bootstrapProps.load(in);
                    }
                    catch (IOException e) {
                        log.error("Error while loading bootstrap properties: {}", (Object)e.toString());
                        throw new ServletException("Error while loading bootstrap properties: " + e.toString());
                    }
                    finally {
                        try {
                            in.close();
                        }
                        catch (IOException e) {}
                    }
                }
            }
            BootstrapConfig tmpConfig = new BootstrapConfig();
            tmpConfig.init(this.getServletConfig());
            tmpConfig.init(bootstrapProps);
            tmpConfig.validate();
            if (!tmpConfig.isValid()) {
                log.error("Repository acesss configuration is not valid.");
                throw new ServletException("Repository access configuration is not valid.");
            }
            tmpConfig.logInfos();
            this.config = tmpConfig;
        }
        return this.config;
    }

    private InitialContext getInitialContext() {
        if (this.jndiContext == null && this.config.getJndiConfig().enabled()) {
            try {
                this.jndiContext = new InitialContext(this.config.getJndiConfig().getJndiEnv());
            }
            catch (NamingException e) {
                log.error("Create initial context: " + e.toString());
            }
        }
        return this.jndiContext;
    }

    private Repository getRepositoryByJNDI() throws ServletException {
        BootstrapConfig config = this.getConfig();
        if (!config.getJndiConfig().isValid() || !config.getJndiConfig().enabled()) {
            return null;
        }
        String repositoryName = config.getRepositoryName();
        InitialContext ctx = this.getInitialContext();
        if (ctx == null) {
            return null;
        }
        try {
            Repository r = (Repository)ctx.lookup(repositoryName);
            log.info("Acquired repository via JNDI.");
            return r;
        }
        catch (NamingException e) {
            log.error("Error while retrieving repository using JNDI (name=" + repositoryName + "): " + e);
            return null;
        }
    }

    private Repository getRepositoryByRMI() throws ServletException {
        ClientFactoryDelegater cfd;
        BootstrapConfig config = this.getConfig();
        if (!config.getRmiConfig().isValid() || !config.getRmiConfig().enabled()) {
            return null;
        }
        String rmiURI = config.getRmiConfig().getRmiUri();
        if (rmiURI == null) {
            return null;
        }
        log.info("  trying to retrieve repository using rmi. uri=" + rmiURI);
        try {
            Class<?> clazz = Class.forName(this.getServerFactoryDelegaterClass());
            cfd = (ClientFactoryDelegater)clazz.newInstance();
        }
        catch (NoClassDefFoundError e) {
            log.error("Unable to locate RMI ClientRepositoryFactory. jcr-rmi.jar missing? " + e.toString());
            return null;
        }
        catch (Exception e) {
            log.error("Unable to locate RMI ClientRepositoryFactory. jcr-rmi.jar missing?" + e.toString());
            return null;
        }
        try {
            Repository r = cfd.getRepository(rmiURI);
            log.info("Acquired repository via RMI.");
            return r;
        }
        catch (Exception e) {
            log.error("Error while retrieving repository using RMI: " + e);
            return null;
        }
    }

    protected Repository getRepositoryByContextAttribute() {
        Repository result = null;
        if (this.repositoryContextAttributeName != null) {
            result = (Repository)this.getServletContext().getAttribute(this.repositoryContextAttributeName);
            if (log.isDebugEnabled()) {
                if (result != null) {
                    log.debug("Got Repository from ServletContext attribute '" + this.repositoryContextAttributeName + "'");
                } else {
                    log.debug("ServletContext attribute '" + this.repositoryContextAttributeName + "' does not provide a Repository");
                }
            }
        }
        return result;
    }

    protected String getServerFactoryDelegaterClass() {
        return ((Object)((Object)this)).getClass().getName() + "$RMIClientFactoryDelegater";
    }

    public Repository getRepository() {
        try {
            if (this.repository == null) {
                this.repository = this.getRepositoryByContextAttribute();
            }
            if (this.repository == null) {
                this.repository = this.getRepositoryByJNDI();
            }
            if (this.repository == null) {
                this.repository = this.getRepositoryByRMI();
            }
            if (this.repository == null) {
                throw new ServletException("N/A");
            }
            return this.repository;
        }
        catch (ServletException e) {
            log.error("The repository is not available. Check config of 'RepositoryAccessServlet'.");
            throw new IllegalStateException("The repository is not available.");
        }
    }

    public static Repository getRepository(ServletContext ctx) {
        return RepositoryAccessServlet.getInstance(ctx).getRepository();
    }

    protected static class RMIClientFactoryDelegater
    extends ClientFactoryDelegater {
        static String FactoryClassName = (class$org$apache$jackrabbit$rmi$client$ClientRepositoryFactory == null ? (class$org$apache$jackrabbit$rmi$client$ClientRepositoryFactory = RepositoryAccessServlet.class$("org.apache.jackrabbit.rmi.client.ClientRepositoryFactory")) : class$org$apache$jackrabbit$rmi$client$ClientRepositoryFactory).getName();

        protected RMIClientFactoryDelegater() {
        }

        public Repository getRepository(String uri) throws MalformedURLException, NotBoundException, RemoteException {
            System.setProperty("java.rmi.server.useCodebaseOnly", "true");
            return new ClientRepositoryFactory().getRepository(uri);
        }
    }

    protected static abstract class ClientFactoryDelegater {
        protected ClientFactoryDelegater() {
        }

        public abstract Repository getRepository(String var1) throws RemoteException, MalformedURLException, NotBoundException;
    }
}

