/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.j2ee;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Properties;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.jackrabbit.j2ee.ServletExceptionWithCause;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.apache.log4j.xml.DOMConfigurator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class LoggingServlet
extends HttpServlet {
    public static final String INIT_PARAM_LOG4J_CONFIG = "log4j-config";

    public void init() throws ServletException {
        this.configure();
        Logger.getRootLogger().info((Object)"Logging initialized.");
    }

    private void configure() throws ServletException {
        String log4jConfig = this.getServletConfig().getInitParameter(INIT_PARAM_LOG4J_CONFIG);
        InputStream in = this.getServletContext().getResourceAsStream(log4jConfig);
        if (in == null) {
            try {
                in = new FileInputStream(log4jConfig);
            }
            catch (FileNotFoundException e) {
                throw new ServletExceptionWithCause("Log4j configuration not found: " + log4jConfig, e);
            }
        } else {
            log4jConfig = "ctx:" + log4jConfig;
        }
        try {
            try {
                if (log4jConfig.endsWith(".xml")) {
                    InputSource ins = new InputSource(in);
                    ins.setSystemId(log4jConfig);
                    this.configureXML(ins);
                } else {
                    this.configureProperties(in);
                }
            }
            catch (IOException e) {
                throw new ServletExceptionWithCause("Log4j configuration failure: " + log4jConfig, e);
            }
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
    }

    private void configureXML(InputSource in) throws ServletException, IOException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            if (in.getSystemId().startsWith("ctx:")) {
                builder.setEntityResolver(new ContextResolver());
            }
            Document document = builder.parse(in);
            Element root = document.getDocumentElement();
            DOMConfigurator.configure((Element)root);
        }
        catch (ParserConfigurationException e) {
            throw new ServletExceptionWithCause("Unable to create XML parser for the configuration", e);
        }
        catch (SAXException e) {
            throw new ServletExceptionWithCause("Configuration file syntax error:" + in.getSystemId(), e);
        }
    }

    private void configureProperties(InputStream in) throws ServletException, IOException {
        Properties log4jProperties = new Properties();
        log4jProperties.load(in);
        PropertyConfigurator.configure((Properties)log4jProperties);
    }

    private class ContextResolver
    implements EntityResolver {
        private ContextResolver() {
        }

        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            try {
                InputStream in;
                URI uri = new URI(systemId);
                if (uri.getScheme().equals("ctx") && (in = LoggingServlet.this.getServletContext().getResourceAsStream(uri.getPath())) != null) {
                    InputSource ins = new InputSource(in);
                    ins.setSystemId(systemId);
                    return ins;
                }
                LoggingServlet.this.log("Error while resolving entity. Unkwon systemid: " + systemId);
            }
            catch (URISyntaxException e) {
                LoggingServlet.this.log("Error while resolving entity: " + e.toString());
            }
            return null;
        }
    }
}

