/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.j2ee;

import java.net.URI;
import java.net.URISyntaxException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import org.apache.jackrabbit.j2ee.AbstractConfig;
import org.apache.jackrabbit.j2ee.BootstrapConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RMIConfig
extends AbstractConfig {
    private static final Logger log;
    private boolean rmiEnabled;
    private int rmiPort = -1;
    private String rmiHost;
    private String rmiName;
    private String rmiUri;
    private final BootstrapConfig parentConfig;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.jackrabbit.j2ee.RMIConfig");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LoggerFactory.getLogger((Class)clazz);
    }

    public RMIConfig(BootstrapConfig parentConfig) {
        this.parentConfig = parentConfig;
    }

    public void init(ServletConfig ctx) throws ServletException {
        super.init(ctx);
        this.rmiEnabled = this.rmiPort >= 0 || this.rmiUri != null;
    }

    public String getRmiName() {
        return this.rmiName;
    }

    public void setRmiName(String rmiName) {
        this.rmiName = rmiName;
    }

    public boolean enabled() {
        return this.rmiEnabled;
    }

    public String getRmiEnabled() {
        return String.valueOf(this.rmiEnabled);
    }

    public void setRmiEnabled(String rmiEnabled) {
        this.rmiEnabled = Boolean.valueOf(rmiEnabled);
    }

    public int rmiPort() {
        return this.rmiPort;
    }

    public String getRmiPort() {
        return String.valueOf(this.rmiPort);
    }

    public void setRmiPort(String rmiPort) {
        this.rmiPort = Integer.decode(rmiPort);
    }

    public String getRmiHost() {
        return this.rmiHost;
    }

    public void setRmiHost(String rmiHost) {
        this.rmiHost = rmiHost;
    }

    public String getRmiUri() {
        return this.rmiUri;
    }

    public void setRmiUri(String rmiUri) {
        this.rmiUri = rmiUri;
    }

    public void validate() {
        if (!this.rmiEnabled) {
            return;
        }
        if (this.rmiUri != null && this.rmiUri.length() > 0) {
            try {
                URI uri = new URI(this.rmiUri);
                this.rmiHost = uri.getHost();
                this.rmiPort = uri.getPort();
                this.rmiName = uri.getPath();
            }
            catch (URISyntaxException e) {
                log.warn("Cannot parse RMI URI '" + this.rmiUri + "'.", (Throwable)e);
                this.rmiUri = null;
                this.rmiHost = null;
            }
            if (this.rmiName != null && this.rmiName.startsWith("/")) {
                this.rmiName = this.rmiName.substring(1);
            }
        }
        if (this.rmiPort == -1 || this.rmiPort == 0) {
            this.rmiPort = 1099;
        } else if (this.rmiPort < -1 || this.rmiPort > 65535) {
            log.warn("Invalid port in rmi-port param " + this.rmiPort + ". using default port.");
            this.rmiPort = 1099;
        }
        if (this.rmiHost == null) {
            this.rmiHost = "";
        }
        if (this.rmiName == null || this.rmiName.length() == 0) {
            this.rmiName = this.parentConfig.getRepositoryName();
        }
        this.rmiUri = "//" + this.rmiHost + ":" + this.rmiPort + "/" + this.rmiName;
        this.valid = true;
    }
}

