/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.j2ee;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Installer {
    private static final Logger log = LoggerFactory.getLogger((Class)Installer.class);
    public static final int C_INSTALL_OK = 0;
    public static final int C_INVALID_INPUT = 1;
    public static final int C_HOME_EXISTS = 2;
    public static final int C_HOME_MISSING = 3;
    public static final int C_CONFIG_EXISTS = 4;
    public static final int C_CONFIG_MISSING = 5;
    public static final int C_BOOTSTRAP_EXISTS = 6;
    public static final int C_INSTALL_ERROR = 7;
    private final File bootstrapConfigFile;
    private final ServletContext context;
    private final String configTemplate = "/org/apache/jackrabbit/core/repository.xml";
    private final String bootstrapTemplate = "/WEB-INF/templates/bootstrap.properties";

    public Installer(File bootstrapConfigFile, ServletContext context) {
        this.bootstrapConfigFile = bootstrapConfigFile;
        this.context = context;
    }

    public int installRepository(HttpServletRequest req) throws ServletException, IOException {
        String repHome = req.getParameter("repository_home");
        String repXml = req.getParameter("repository_xml");
        String mode = req.getParameter("mode");
        if (repHome == null || mode == null) {
            return 1;
        }
        if (repXml == null || repXml.length() == 0) {
            repXml = repHome + "/repository.xml";
        }
        File home = new File(repHome);
        File config = new File(repXml);
        if ("new".equals(mode)) {
            if (new File(home, "repository").exists()) {
                log.error("Trying to install new repository home '{}' but it already contain a repository", (Object)repHome);
                return 2;
            }
            if (config.exists()) {
                log.error("Trying to install new repository config '{}' but already exists", (Object)repXml);
                return 4;
            }
            log.info("Creating new repository home '{}'", (Object)repHome);
            home.mkdirs();
            try {
                this.installRepositoryConfig(config);
            }
            catch (IOException e) {
                log.error("Error while installing new repository config '{}': {}", (Object)repXml, (Object)e.toString());
                return 6;
            }
        } else {
            if (!home.exists()) {
                log.error("Trying to use exisintg repository home '{}' but does not exists", (Object)repHome);
                return 3;
            }
            if (!config.exists()) {
                log.error("Trying to use existing repository config '{}' but does not exists", (Object)repXml);
                return 5;
            }
        }
        try {
            this.installBootstrap(this.bootstrapConfigFile, repHome, repXml);
        }
        catch (IOException e) {
            log.error("Error while installing '{}': {}", (Object)this.bootstrapConfigFile.getPath(), (Object)e.toString());
            return 7;
        }
        return 0;
    }

    private void installRepositoryConfig(File dest) throws IOException {
        int read;
        log.info("Creating new repository config: {}", (Object)dest.getPath());
        InputStream in = this.context.getResourceAsStream("/org/apache/jackrabbit/core/repository.xml");
        if (in == null) {
            in = this.getClass().getResourceAsStream("/org/apache/jackrabbit/core/repository.xml");
        }
        FileOutputStream out = new FileOutputStream(dest);
        byte[] buffer = new byte[8192];
        while ((read = in.read(buffer)) >= 0) {
            ((OutputStream)out).write(buffer, 0, read);
        }
        in.close();
        ((OutputStream)out).close();
    }

    private void installBootstrap(File dest, String repHome, String repXml) throws IOException {
        log.info("Creating new bootstrap properties: {}", (Object)dest.getPath());
        InputStream in = this.context.getResourceAsStream("/WEB-INF/templates/bootstrap.properties");
        Properties props = new Properties();
        props.load(in);
        props.setProperty("repository.home", repHome);
        props.setProperty("repository.config", repXml);
        in.close();
        if (!dest.getParentFile().exists()) {
            dest.getParentFile().mkdirs();
        }
        FileOutputStream out = new FileOutputStream(dest);
        props.store(out, "bootstrap properties for the repository startup servlet.");
        ((OutputStream)out).close();
    }
}

