/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.j2ee;

import java.util.Enumeration;
import java.util.Properties;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import org.apache.jackrabbit.j2ee.AbstractConfig;
import org.apache.jackrabbit.j2ee.BootstrapConfig;

public class JNDIConfig
extends AbstractConfig {
    private boolean jndiEnabled;
    private String jndiName;
    private final BootstrapConfig parentConfig;
    private Properties jndiEnv = new Properties();

    public JNDIConfig(BootstrapConfig parentConfig) {
        this.parentConfig = parentConfig;
    }

    public String getJndiName() {
        return this.jndiName;
    }

    public void setJndiName(String jndiName) {
        this.jndiName = jndiName;
    }

    public boolean enabled() {
        return this.jndiEnabled;
    }

    public String getJndiEnabled() {
        return String.valueOf(this.jndiEnabled);
    }

    public void setJndiEnabled(String jndiEnabled) {
        this.jndiEnabled = Boolean.valueOf(jndiEnabled);
    }

    public Properties getJndiEnv() {
        return this.jndiEnv;
    }

    @Override
    public void init(Properties props) throws ServletException {
        super.init(props);
        for (String string : props.keySet()) {
            if (!string.startsWith("java.naming.")) continue;
            this.jndiEnv.put(string, props.getProperty(string));
        }
    }

    @Override
    public void init(ServletConfig ctx) throws ServletException {
        super.init(ctx);
        Enumeration names = ctx.getInitParameterNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            if (!name.startsWith("java.naming.")) continue;
            this.jndiEnv.put(name, ctx.getInitParameter(name));
        }
        this.jndiEnabled = this.jndiEnv.containsKey("java.naming.provider.url");
    }

    @Override
    public void validate() {
        if (this.jndiName == null) {
            this.jndiName = this.parentConfig.getRepositoryName();
        }
        this.valid = true;
    }
}

