/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.webdav.client.methods;

import java.io.IOException;
import org.apache.commons.httpclient.HttpConnection;
import org.apache.commons.httpclient.HttpState;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.client.methods.DavMethodBase;
import org.apache.jackrabbit.webdav.header.PollTimeoutHeader;
import org.apache.jackrabbit.webdav.observation.EventBundle;
import org.apache.jackrabbit.webdav.observation.EventDiscovery;
import org.apache.jackrabbit.webdav.observation.ObservationConstants;
import org.apache.jackrabbit.webdav.xml.DomUtil;
import org.apache.jackrabbit.webdav.xml.ElementIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class PollMethod
extends DavMethodBase
implements ObservationConstants {
    private static Logger log;
    private EventDiscovery eventDiscovery;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.jackrabbit.webdav.client.methods.PollMethod");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LoggerFactory.getLogger((Class)clazz);
    }

    public PollMethod(String uri, String subscriptionId) {
        this(uri, subscriptionId, 0L);
    }

    public PollMethod(String uri, String subscriptionId, long timeout) {
        super(uri);
        this.setRequestHeader("SubscriptionId", subscriptionId);
        if (timeout > 0L) {
            this.setRequestHeader(new PollTimeoutHeader(timeout));
        }
    }

    public EventDiscovery getResponseAsEventDiscovery() throws IOException, DavException {
        this.checkUsed();
        if (this.eventDiscovery != null) {
            return this.eventDiscovery;
        }
        DavException dx = this.getResponseException();
        if (dx != null) {
            throw dx;
        }
        throw new DavException(this.getStatusCode(), String.valueOf(this.getName()) + " resulted with unexpected status: " + this.getStatusLine());
    }

    public String getName() {
        return "POLL";
    }

    protected boolean isSuccess(int statusCode) {
        return 200 == statusCode;
    }

    protected void processResponseBody(HttpState httpState, HttpConnection httpConnection) {
        if (this.getSuccess()) {
            try {
                this.setSuccess(this.buildDiscoveryFromRoot(this.getRootElement()));
            }
            catch (IOException e) {
                log.error("Error while parsing multistatus response: " + e);
                this.setSuccess(false);
            }
        }
    }

    private boolean buildDiscoveryFromRoot(Element root) {
        if (DomUtil.matches(root, "eventdiscovery", ObservationConstants.NAMESPACE)) {
            this.eventDiscovery = new EventDiscovery();
            ElementIterator it = DomUtil.getChildren(root, "eventbundle", ObservationConstants.NAMESPACE);
            while (it.hasNext()) {
                final Element ebElement = it.nextElement();
                EventBundle eb = new EventBundle(){

                    public Element toXml(Document document) {
                        return (Element)document.importNode(ebElement, true);
                    }
                };
                this.eventDiscovery.addEventBundle(eb);
            }
            return true;
        }
        log.debug("Missing 'eventdiscovery' response body in POLL method.");
        return false;
    }
}

