/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.webdav.client.methods;

import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.jackrabbit.webdav.client.methods.DavMethodBase;
import org.apache.jackrabbit.webdav.header.DepthHeader;
import org.apache.jackrabbit.webdav.property.DavPropertyNameSet;
import org.apache.jackrabbit.webdav.xml.DomUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class PropFindMethod
extends DavMethodBase {
    private static Logger log;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.jackrabbit.webdav.client.methods.PropFindMethod");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LoggerFactory.getLogger((Class)clazz);
    }

    public PropFindMethod(String uri) throws IOException {
        this(uri, 1, new DavPropertyNameSet(), Integer.MAX_VALUE);
    }

    public PropFindMethod(String uri, DavPropertyNameSet propNameSet, int depth) throws IOException {
        this(uri, 0, propNameSet, depth);
    }

    public PropFindMethod(String uri, int propfindType, int depth) throws IOException {
        this(uri, propfindType, new DavPropertyNameSet(), depth);
    }

    public PropFindMethod(String uri, int propfindType, DavPropertyNameSet propNameSet, int depth) throws IOException {
        super(uri);
        DepthHeader dh = new DepthHeader(depth);
        this.setRequestHeader(dh.getHeaderName(), dh.getHeaderValue());
        try {
            Document document = BUILDER_FACTORY.newDocumentBuilder().newDocument();
            Element propfind = DomUtil.createElement(document, "propfind", NAMESPACE);
            document.appendChild(propfind);
            switch (propfindType) {
                case 1: {
                    propfind.appendChild(DomUtil.createElement(document, "allprop", NAMESPACE));
                    break;
                }
                case 2: {
                    propfind.appendChild(DomUtil.createElement(document, "propname", NAMESPACE));
                    break;
                }
                case 0: {
                    if (propNameSet == null) {
                        Element prop = DomUtil.createElement(document, "prop", NAMESPACE);
                        Element resourcetype = DomUtil.createElement(document, "resourcetype", NAMESPACE);
                        prop.appendChild(resourcetype);
                        propfind.appendChild(prop);
                        break;
                    }
                    propfind.appendChild(propNameSet.toXml(document));
                    break;
                }
                case 3: {
                    propfind.appendChild(DomUtil.createElement(document, "allprop", NAMESPACE));
                    if (propNameSet == null || propNameSet.isEmpty()) break;
                    Element include = DomUtil.createElement(document, "include", NAMESPACE);
                    Element prop = propNameSet.toXml(document);
                    Node c = prop.getFirstChild();
                    while (c != null) {
                        include.appendChild(c.cloneNode(true));
                        c = c.getNextSibling();
                    }
                    propfind.appendChild(include);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unknown propfind type");
                }
            }
            this.setRequestBody(document);
        }
        catch (ParserConfigurationException e) {
            throw new IOException(e.getMessage());
        }
    }

    public String getName() {
        return "PROPFIND";
    }

    protected boolean isSuccess(int statusCode) {
        return statusCode == 207;
    }
}

