/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.webdav.header;

import javax.servlet.http.HttpServletRequest;
import org.apache.jackrabbit.webdav.header.Header;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CodedUrlHeader
implements Header {
    private static Logger log;
    private final String headerName;
    private final String headerValue;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.jackrabbit.webdav.header.CodedUrlHeader");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LoggerFactory.getLogger((Class)clazz);
    }

    public CodedUrlHeader(String headerName, String headerValue) {
        this.headerName = headerName;
        if (!(headerValue == null || headerValue.startsWith("<") && headerValue.endsWith(">"))) {
            headerValue = "<" + headerValue + ">";
        }
        this.headerValue = headerValue;
    }

    public String getHeaderName() {
        return this.headerName;
    }

    public String getHeaderValue() {
        return this.headerValue;
    }

    public String getCodedUrl() {
        String[] codedUrls = this.getCodedUrls();
        return codedUrls != null ? codedUrls[0] : null;
    }

    public String[] getCodedUrls() {
        String[] codedUrls = null;
        if (this.headerValue != null) {
            String[] values = this.headerValue.split(",");
            codedUrls = new String[values.length];
            int i = 0;
            while (i < values.length) {
                int p1 = values[i].indexOf(60);
                if (p1 < 0) {
                    throw new IllegalArgumentException("Invalid CodedURL header value:" + values[i]);
                }
                int p2 = values[i].indexOf(62, p1);
                if (p2 < 0) {
                    throw new IllegalArgumentException("Invalid CodedURL header value:" + values[i]);
                }
                codedUrls[i] = values[i].substring(p1 + 1, p2);
                ++i;
            }
        }
        return codedUrls;
    }

    public static CodedUrlHeader parse(HttpServletRequest request, String headerName) {
        String headerValue = request.getHeader(headerName);
        return new CodedUrlHeader(headerName, headerValue);
    }
}

