/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.webdav.header;

import javax.servlet.http.HttpServletRequest;
import org.apache.jackrabbit.webdav.DavConstants;
import org.apache.jackrabbit.webdav.header.Header;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeoutHeader
implements Header,
DavConstants {
    private static Logger log;
    private final long timeout;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.jackrabbit.webdav.header.TimeoutHeader");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LoggerFactory.getLogger((Class)clazz);
    }

    public TimeoutHeader(long timeout) {
        this.timeout = timeout;
    }

    public String getHeaderName() {
        return "Timeout";
    }

    public String getHeaderValue() {
        if (this.timeout == Integer.MAX_VALUE) {
            return "Infinite";
        }
        return "Second-" + this.timeout / 1000L;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public static TimeoutHeader parse(HttpServletRequest request, long defaultValue) {
        String timeoutStr = request.getHeader("Timeout");
        long timeout = TimeoutHeader.parse(timeoutStr, defaultValue);
        return new TimeoutHeader(timeout);
    }

    public static long parse(String timeoutStr, long defaultValue) {
        long timeout = defaultValue;
        if (timeoutStr != null && timeoutStr.length() > 0) {
            int secondsInd = timeoutStr.indexOf("Second-");
            if (secondsInd >= 0) {
                int i = secondsInd += 7;
                while (i < timeoutStr.length() && Character.isDigit(timeoutStr.charAt(i))) {
                    ++i;
                }
                try {
                    timeout = 1000L * Long.parseLong(timeoutStr.substring(secondsInd, i));
                }
                catch (NumberFormatException ignore) {
                    log.error("Invalid timeout format: " + timeoutStr);
                }
            } else if (timeoutStr.equalsIgnoreCase("Infinite")) {
                timeout = Integer.MAX_VALUE;
            }
        }
        return timeout;
    }
}

