/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.webdav.property;

import java.util.Collection;
import java.util.Iterator;
import org.apache.jackrabbit.webdav.property.DavProperty;
import org.apache.jackrabbit.webdav.property.DavPropertyName;
import org.apache.jackrabbit.webdav.xml.DomUtil;
import org.apache.jackrabbit.webdav.xml.XmlSerializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class AbstractDavProperty
implements DavProperty {
    private static Logger log;
    private final DavPropertyName name;
    private final boolean isInvisibleInAllprop;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.jackrabbit.webdav.property.AbstractDavProperty");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LoggerFactory.getLogger((Class)clazz);
    }

    public AbstractDavProperty(DavPropertyName name, boolean isInvisibleInAllprop) {
        this.name = name;
        this.isInvisibleInAllprop = isInvisibleInAllprop;
    }

    public int hashCode() {
        int hashCode = this.getName().hashCode();
        if (this.getValue() != null) {
            hashCode += this.getValue().hashCode();
        }
        return hashCode % Integer.MAX_VALUE;
    }

    public boolean equals(Object obj) {
        if (obj instanceof DavProperty) {
            boolean equalValue;
            DavProperty prop = (DavProperty)obj;
            boolean equalName = this.getName().equals(prop.getName());
            boolean bl = this.getValue() == null ? prop.getValue() == null : (equalValue = this.getValue().equals(prop.getValue()));
            return equalName && equalValue;
        }
        return false;
    }

    public Element toXml(Document document) {
        Element elem = this.getName().toXml(document);
        Object value = this.getValue();
        if (value != null) {
            if (value instanceof XmlSerializable) {
                elem.appendChild(((XmlSerializable)value).toXml(document));
            } else if (value instanceof Node) {
                Node n = document.importNode((Node)value, true);
                elem.appendChild(n);
            } else if (value instanceof Node[]) {
                int i = 0;
                while (i < ((Node[])value).length) {
                    Node n = document.importNode(((Node[])value)[i], true);
                    elem.appendChild(n);
                    ++i;
                }
            } else if (value instanceof Collection) {
                Iterator it = ((Collection)value).iterator();
                while (it.hasNext()) {
                    Object entry = it.next();
                    if (entry instanceof XmlSerializable) {
                        elem.appendChild(((XmlSerializable)entry).toXml(document));
                        continue;
                    }
                    if (entry instanceof Node) {
                        Node n = document.importNode((Node)entry, true);
                        elem.appendChild(n);
                        continue;
                    }
                    DomUtil.setText(elem, entry.toString());
                }
            } else {
                DomUtil.setText(elem, value.toString());
            }
        }
        return elem;
    }

    public DavPropertyName getName() {
        return this.name;
    }

    public boolean isInvisibleInAllprop() {
        return this.isInvisibleInAllprop;
    }
}

