/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.webdav.security;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.property.AbstractDavProperty;
import org.apache.jackrabbit.webdav.property.DavProperty;
import org.apache.jackrabbit.webdav.security.Privilege;
import org.apache.jackrabbit.webdav.security.SecurityConstants;
import org.w3c.dom.Element;

public class CurrentUserPrivilegeSetProperty
extends AbstractDavProperty {
    private final Set privileges;

    public CurrentUserPrivilegeSetProperty(Privilege[] privileges) {
        super(SecurityConstants.CURRENT_USER_PRIVILEGE_SET, true);
        this.privileges = new HashSet();
        int i = 0;
        while (i < privileges.length) {
            if (privileges[i] != null) {
                this.privileges.add(privileges[i]);
            }
            ++i;
        }
    }

    public CurrentUserPrivilegeSetProperty(DavProperty xmlDavProperty) throws DavException {
        super(xmlDavProperty.getName(), true);
        if (!SecurityConstants.CURRENT_USER_PRIVILEGE_SET.equals(this.getName())) {
            throw new DavException(400, "DAV:current-user-privilege-set expected.");
        }
        this.privileges = new HashSet();
        Object value = xmlDavProperty.getValue();
        if (value != null) {
            if (value instanceof Element) {
                this.privileges.add(Privilege.getPrivilege((Element)value));
            } else if (value instanceof Collection) {
                Iterator it = ((Collection)value).iterator();
                while (it.hasNext()) {
                    Object entry = it.next();
                    if (!(entry instanceof Element)) continue;
                    this.privileges.add(Privilege.getPrivilege((Element)entry));
                }
            }
        }
    }

    public Object getValue() {
        return this.privileges;
    }
}

