/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.webdav.security.report;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.DavResource;
import org.apache.jackrabbit.webdav.DavResourceLocator;
import org.apache.jackrabbit.webdav.MultiStatusResponse;
import org.apache.jackrabbit.webdav.property.DavProperty;
import org.apache.jackrabbit.webdav.security.AclProperty;
import org.apache.jackrabbit.webdav.security.SecurityConstants;
import org.apache.jackrabbit.webdav.security.report.AbstractSecurityReport;
import org.apache.jackrabbit.webdav.version.report.ReportInfo;
import org.apache.jackrabbit.webdav.version.report.ReportType;

public class AclPrincipalReport
extends AbstractSecurityReport {
    public static final String REPORT_NAME = "acl-principal-prop-set";
    public static final ReportType REPORT_TYPE;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.jackrabbit.webdav.security.report.AclPrincipalReport");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        REPORT_TYPE = ReportType.register(REPORT_NAME, SecurityConstants.NAMESPACE, clazz);
    }

    public ReportType getType() {
        return REPORT_TYPE;
    }

    public void init(DavResource resource, ReportInfo info) throws DavException {
        super.init(resource, info);
        DavProperty acl = resource.getProperty(SecurityConstants.ACL);
        if (!(acl instanceof AclProperty)) {
            throw new DavException(500, "DAV:acl property expected.");
        }
        DavResourceLocator loc = resource.getLocator();
        HashMap<String, MultiStatusResponse> principalMap = new HashMap<String, MultiStatusResponse>();
        Iterator aceIt = ((List)((AclProperty)acl).getValue()).iterator();
        while (aceIt.hasNext()) {
            AclProperty.Ace ace = (AclProperty.Ace)aceIt.next();
            String href = ace.getPrincipal().getHref();
            if (href == null && principalMap.containsKey(href)) continue;
            DavResourceLocator princLocator = loc.getFactory().createResourceLocator(loc.getPrefix(), href);
            DavResource principalResource = resource.getFactory().createResource(princLocator, resource.getSession());
            principalMap.put(href, new MultiStatusResponse(principalResource, info.getPropertyNameSet()));
        }
        this.responses = principalMap.values().toArray(new MultiStatusResponse[principalMap.size()]);
    }
}

