/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.webdav.security.report;

import java.util.Iterator;
import java.util.List;
import org.apache.jackrabbit.webdav.DavConstants;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.DavResource;
import org.apache.jackrabbit.webdav.MultiStatusResponse;
import org.apache.jackrabbit.webdav.property.DavPropertyNameSet;
import org.apache.jackrabbit.webdav.property.HrefProperty;
import org.apache.jackrabbit.webdav.security.SecurityConstants;
import org.apache.jackrabbit.webdav.security.report.AbstractSecurityReport;
import org.apache.jackrabbit.webdav.version.report.ReportInfo;
import org.apache.jackrabbit.webdav.version.report.ReportType;
import org.apache.jackrabbit.webdav.xml.DomUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class PrincipalSearchReport
extends AbstractSecurityReport {
    private static Logger log;
    public static final String XML_APPLY_TO_PRINCIPAL_COLLECTION_SET = "apply-to-principal-collection-set";
    public static final String XML_PROPERTY_SEARCH = "property-search";
    public static final String XML_MATCH = "match";
    public static final String REPORT_NAME = "principal-property-search";
    public static final ReportType REPORT_TYPE;
    private String[] searchRoots;
    private SearchArgument[] searchArguments;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.jackrabbit.webdav.security.report.PrincipalSearchReport");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LoggerFactory.getLogger((Class)clazz);
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.apache.jackrabbit.webdav.security.report.PrincipalSearchReport");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        REPORT_TYPE = ReportType.register(REPORT_NAME, SecurityConstants.NAMESPACE, clazz2);
    }

    public ReportType getType() {
        return REPORT_TYPE;
    }

    public void init(DavResource resource, ReportInfo info) throws DavException {
        super.init(resource, info);
        if (!info.containsContentElement(XML_PROPERTY_SEARCH, SecurityConstants.NAMESPACE)) {
            throw new DavException(400, "Request body must contain at least a single DAV:property-search element.");
        }
        List psElements = info.getContentElements(XML_PROPERTY_SEARCH, SecurityConstants.NAMESPACE);
        this.searchArguments = new SearchArgument[psElements.size()];
        Iterator it = psElements.iterator();
        int i = 0;
        while (it.hasNext()) {
            this.searchArguments[i++] = new SearchArgument((Element)it.next());
        }
        if (info.containsContentElement(XML_APPLY_TO_PRINCIPAL_COLLECTION_SET, SecurityConstants.NAMESPACE)) {
            HrefProperty p = new HrefProperty(resource.getProperty(SecurityConstants.PRINCIPAL_COLLECTION_SET));
            this.searchRoots = p.getHrefs().toArray(new String[0]);
        } else {
            this.searchRoots = new String[]{resource.getHref()};
        }
    }

    public String[] getSearchRoots() {
        return this.searchRoots;
    }

    public SearchArgument[] getSearchArguments() {
        return this.searchArguments;
    }

    public void setResponses(MultiStatusResponse[] responses) {
        this.responses = responses;
    }

    protected class SearchArgument {
        private final DavPropertyNameSet searchProps;
        private final String searchString;

        private SearchArgument(Element propSearch) {
            this.searchProps = new DavPropertyNameSet(DomUtil.getChildElement(propSearch, "prop", DavConstants.NAMESPACE));
            this.searchString = DomUtil.getChildText(propSearch, PrincipalSearchReport.XML_MATCH, SecurityConstants.NAMESPACE);
        }

        protected DavPropertyNameSet getSearchProperties() {
            return this.searchProps;
        }

        protected String getSearchString() {
            return this.searchString;
        }
    }
}

