/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.webdav.version;

import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.version.DeltaVConstants;
import org.apache.jackrabbit.webdav.xml.DomUtil;
import org.apache.jackrabbit.webdav.xml.XmlSerializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class LabelInfo
implements DeltaVConstants,
XmlSerializable {
    private static Logger log;
    public static final int TYPE_SET = 0;
    public static final int TYPE_REMOVE = 1;
    public static final int TYPE_ADD = 2;
    public static String[] typeNames;
    private final int depth;
    private final int type;
    private final String labelName;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.jackrabbit.webdav.version.LabelInfo");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LoggerFactory.getLogger((Class)clazz);
        typeNames = new String[]{"set", "remove", "add"};
    }

    public LabelInfo(String labelName, String type) {
        if (labelName == null) {
            throw new IllegalArgumentException("Label name must not be null.");
        }
        boolean validType = false;
        int i = 0;
        while (i < typeNames.length) {
            if (typeNames[i].equals(type)) {
                validType = true;
                break;
            }
            ++i;
        }
        if (!validType) {
            throw new IllegalArgumentException("Invalid type: " + type);
        }
        this.type = i;
        this.labelName = labelName;
        this.depth = 0;
    }

    public LabelInfo(String labelName, int type) {
        this(labelName, type, 0);
    }

    public LabelInfo(String labelName, int type, int depth) {
        if (labelName == null) {
            throw new IllegalArgumentException("Label name must not be null.");
        }
        if (type < 0 || type > 2) {
            throw new IllegalArgumentException("Invalid type: " + type);
        }
        this.labelName = labelName;
        this.type = type;
        this.depth = depth;
    }

    public LabelInfo(Element labelElement, int depth) throws DavException {
        if (!DomUtil.matches(labelElement, "label", DeltaVConstants.NAMESPACE)) {
            log.warn("DAV:label element expected");
            throw new DavException(400);
        }
        String label = null;
        int type = -1;
        int i = 0;
        while (i < typeNames.length && type == -1) {
            if (DomUtil.hasChildElement(labelElement, typeNames[i], NAMESPACE)) {
                type = i;
                Element el = DomUtil.getChildElement(labelElement, typeNames[i], NAMESPACE);
                label = DomUtil.getChildText(el, "label-name", NAMESPACE);
            }
            ++i;
        }
        if (label == null) {
            log.warn("DAV:label element must contain at least one set, add or remove element defining a label-name.");
            throw new DavException(400);
        }
        this.labelName = label;
        this.type = type;
        this.depth = depth;
    }

    public LabelInfo(Element labelElement) throws DavException {
        this(labelElement, 0);
    }

    public String getLabelName() {
        return this.labelName;
    }

    public int getType() {
        return this.type;
    }

    public int getDepth() {
        return this.depth;
    }

    public Element toXml(Document document) {
        Element label = DomUtil.createElement(document, "label", NAMESPACE);
        Element typeElem = DomUtil.addChildElement(label, typeNames[this.type], NAMESPACE);
        DomUtil.addChildElement(typeElem, "label-name", NAMESPACE, this.labelName);
        return label;
    }
}

