/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.webdav.version;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.version.DeltaVConstants;
import org.apache.jackrabbit.webdav.xml.DomUtil;
import org.apache.jackrabbit.webdav.xml.ElementIterator;
import org.apache.jackrabbit.webdav.xml.Namespace;
import org.apache.jackrabbit.webdav.xml.XmlSerializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class OptionsInfo
implements XmlSerializable {
    private static Logger log;
    private final Set entriesLocalNames = new HashSet();
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.jackrabbit.webdav.version.OptionsInfo");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LoggerFactory.getLogger((Class)clazz);
    }

    public OptionsInfo(String[] entriesLocalNames) {
        if (entriesLocalNames != null) {
            int i = 0;
            while (i < entriesLocalNames.length) {
                this.entriesLocalNames.add(entriesLocalNames[i]);
                ++i;
            }
        }
    }

    private OptionsInfo() {
    }

    public boolean containsElement(String localName, Namespace namespace) {
        if (DeltaVConstants.NAMESPACE.equals(namespace)) {
            return this.entriesLocalNames.contains(localName);
        }
        return false;
    }

    public Element toXml(Document document) {
        Element optionsElem = DomUtil.createElement(document, "options", DeltaVConstants.NAMESPACE);
        Iterator it = this.entriesLocalNames.iterator();
        while (it.hasNext()) {
            String localName = (String)it.next();
            DomUtil.addChildElement(optionsElem, localName, DeltaVConstants.NAMESPACE);
        }
        return optionsElem;
    }

    public static OptionsInfo createFromXml(Element optionsElement) throws DavException {
        if (!DomUtil.matches(optionsElement, "options", DeltaVConstants.NAMESPACE)) {
            log.warn("DAV:options element expected");
            throw new DavException(400);
        }
        OptionsInfo oInfo = new OptionsInfo();
        ElementIterator it = DomUtil.getChildren(optionsElement);
        while (it.hasNext()) {
            oInfo.entriesLocalNames.add(it.nextElement().getLocalName());
        }
        return oInfo;
    }
}

