/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.webdav.version.report;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.jackrabbit.webdav.DavConstants;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.DavResource;
import org.apache.jackrabbit.webdav.DavResourceIterator;
import org.apache.jackrabbit.webdav.DavResourceLocator;
import org.apache.jackrabbit.webdav.property.HrefProperty;
import org.apache.jackrabbit.webdav.version.BaselineResource;
import org.apache.jackrabbit.webdav.version.DeltaVConstants;
import org.apache.jackrabbit.webdav.version.VersionControlledResource;
import org.apache.jackrabbit.webdav.version.VersionResource;
import org.apache.jackrabbit.webdav.version.report.Report;
import org.apache.jackrabbit.webdav.version.report.ReportInfo;
import org.apache.jackrabbit.webdav.version.report.ReportType;
import org.apache.jackrabbit.webdav.xml.DomUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class CompareBaselineReport
implements Report {
    private static Logger log;
    private static final String XML_COMPARE_BASELINE = "compare-baseline";
    private static final String XML_COMPARE_BASELINE_REPORT = "compare-baseline-report";
    private static final String XML_ADDED_VERSION = "added-version";
    private static final String XML_DELETED_VERSION = "deleted-version";
    private static final String XML_CHANGED_VERSION = "changed-version";
    public static final ReportType COMPARE_BASELINE;
    private BaselineResource requestBaseline;
    private BaselineResource compareBaseline;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.jackrabbit.webdav.version.report.CompareBaselineReport");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LoggerFactory.getLogger((Class)clazz);
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.apache.jackrabbit.webdav.version.report.CompareBaselineReport");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        COMPARE_BASELINE = ReportType.register(XML_COMPARE_BASELINE, DeltaVConstants.NAMESPACE, clazz2);
    }

    public ReportType getType() {
        return COMPARE_BASELINE;
    }

    public boolean isMultiStatusReport() {
        return false;
    }

    public void init(DavResource resource, ReportInfo info) throws DavException {
        if (!this.getType().isRequestedReportType(info)) {
            throw new DavException(400, "DAV:compare-baseline element expected.");
        }
        if (resource == null || !(resource instanceof BaselineResource)) {
            throw new DavException(400, "DAV:compare-baseline report can only be created for a baseline resource.");
        }
        this.requestBaseline = (BaselineResource)resource;
        String compareHref = DomUtil.getText(info.getContentElement("href", DavConstants.NAMESPACE));
        DavResourceLocator locator = resource.getLocator();
        DavResourceLocator compareLocator = locator.getFactory().createResourceLocator(locator.getPrefix(), compareHref);
        DavResource compRes = resource.getFactory().createResource(compareLocator, resource.getSession());
        if (!(compRes instanceof BaselineResource)) {
            throw new DavException(400, "DAV:latest-activity-version report: The DAV:href in the request body MUST identify an activity.");
        }
        this.compareBaseline = (BaselineResource)compRes;
    }

    public Element toXml(Document document) {
        Element el = DomUtil.createElement(document, XML_COMPARE_BASELINE_REPORT, DeltaVConstants.NAMESPACE);
        try {
            ArrayList requestVs = new ArrayList();
            this.getVersions(this.requestBaseline.getBaselineCollection(), requestVs);
            ArrayList compareVs = new ArrayList();
            this.getVersions(this.compareBaseline.getBaselineCollection(), compareVs);
            VersionResource[] rArr = requestVs.toArray(new VersionResource[requestVs.size()]);
            int i = 0;
            while (i < rArr.length) {
                VersionResource requestV = rArr[i];
                if (!compareVs.remove(requestV)) {
                    Element cv;
                    VersionResource changedV = this.findChangedVersion(requestV, compareVs);
                    if (changedV != null) {
                        cv = DomUtil.addChildElement(el, XML_CHANGED_VERSION, DeltaVConstants.NAMESPACE);
                        cv.appendChild(DomUtil.hrefToXml(requestV.getHref(), document));
                        cv.appendChild(DomUtil.hrefToXml(changedV.getHref(), document));
                    } else {
                        cv = DomUtil.addChildElement(el, XML_DELETED_VERSION, DeltaVConstants.NAMESPACE);
                        cv.appendChild(DomUtil.hrefToXml(requestV.getHref(), document));
                    }
                }
                ++i;
            }
            Iterator it = compareVs.iterator();
            while (it.hasNext()) {
                VersionResource addedV = (VersionResource)it.next();
                Element cv = DomUtil.addChildElement(el, XML_ADDED_VERSION, DeltaVConstants.NAMESPACE);
                cv.appendChild(DomUtil.hrefToXml(addedV.getHref(), document));
            }
        }
        catch (DavException e) {
            log.error("Internal error while building report", (Throwable)e);
        }
        return el;
    }

    private void getVersions(DavResource collection, List vList) throws DavException {
        DavResourceIterator it = collection.getMembers();
        while (it.hasNext()) {
            DavResource member = it.nextResource();
            if (member instanceof VersionControlledResource) {
                String href = (String)new HrefProperty(member.getProperty(VersionControlledResource.CHECKED_IN)).getHrefs().get(0);
                DavResourceLocator locator = member.getLocator();
                DavResourceLocator vLocator = locator.getFactory().createResourceLocator(locator.getPrefix(), href);
                DavResource v = member.getFactory().createResource(vLocator, member.getSession());
                if (v instanceof VersionResource) {
                    vList.add(v);
                } else {
                    log.error("Internal error: DAV:checked-in property must point to a VersionResource.");
                }
            }
            if (!member.isCollection()) continue;
            this.getVersions(member, vList);
        }
    }

    private VersionResource findChangedVersion(VersionResource requestV, List compareVs) throws DavException {
        VersionResource[] vs = requestV.getVersionHistory().getVersions();
        int i = 0;
        while (i < vs.length) {
            if (compareVs.remove(vs[i])) {
                return vs[i];
            }
            ++i;
        }
        return null;
    }
}

