/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.webdav.version.report;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.DavResource;
import org.apache.jackrabbit.webdav.DavResourceIterator;
import org.apache.jackrabbit.webdav.MultiStatus;
import org.apache.jackrabbit.webdav.MultiStatusResponse;
import org.apache.jackrabbit.webdav.property.AbstractDavProperty;
import org.apache.jackrabbit.webdav.property.DavProperty;
import org.apache.jackrabbit.webdav.property.DavPropertyName;
import org.apache.jackrabbit.webdav.property.HrefProperty;
import org.apache.jackrabbit.webdav.version.DeltaVConstants;
import org.apache.jackrabbit.webdav.version.DeltaVResource;
import org.apache.jackrabbit.webdav.version.report.Report;
import org.apache.jackrabbit.webdav.version.report.ReportInfo;
import org.apache.jackrabbit.webdav.version.report.ReportType;
import org.apache.jackrabbit.webdav.xml.DomUtil;
import org.apache.jackrabbit.webdav.xml.ElementIterator;
import org.apache.jackrabbit.webdav.xml.Namespace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ExpandPropertyReport
implements Report,
DeltaVConstants {
    private static Logger log;
    private DavResource resource;
    private ReportInfo info;
    private Iterator propertyElements;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.jackrabbit.webdav.version.report.ExpandPropertyReport");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LoggerFactory.getLogger((Class)clazz);
    }

    public ReportType getType() {
        return ReportType.EXPAND_PROPERTY;
    }

    public boolean isMultiStatusReport() {
        return true;
    }

    public void init(DavResource resource, ReportInfo info) throws DavException {
        this.setResource(resource);
        this.setInfo(info);
    }

    private void setResource(DavResource resource) throws DavException {
        if (resource == null) {
            throw new DavException(400, "The resource specified must not be null.");
        }
        this.resource = resource;
    }

    private void setInfo(ReportInfo info) throws DavException {
        if (info == null) {
            throw new DavException(400, "The report info specified must not be null.");
        }
        if (!this.getType().isRequestedReportType(info)) {
            throw new DavException(400, "DAV:expand-property element expected.");
        }
        this.info = info;
        this.propertyElements = info.getContentElements("property", NAMESPACE).iterator();
    }

    public Element toXml(Document document) {
        return this.getMultiStatus().toXml(document);
    }

    private MultiStatus getMultiStatus() {
        MultiStatus ms = new MultiStatus();
        this.addResponses(this.resource, this.info.getDepth(), ms);
        return ms;
    }

    private void addResponses(DavResource res, int depth, MultiStatus ms) {
        MultiStatusResponse response = this.getResponse(res, this.propertyElements);
        ms.addResponse(response);
        if (depth > 0 && res.isCollection()) {
            DavResourceIterator it = res.getMembers();
            while (it.hasNext()) {
                this.addResponses(it.nextResource(), depth - 1, ms);
            }
        }
    }

    private MultiStatusResponse getResponse(DavResource res, Iterator propertyElements) {
        MultiStatusResponse resp = new MultiStatusResponse(res.getHref(), null);
        while (propertyElements.hasNext()) {
            Element propertyElem = (Element)propertyElements.next();
            String nameAttr = propertyElem.getAttribute("name");
            if (nameAttr == null || "".equals(nameAttr)) continue;
            String namespaceAttr = propertyElem.getAttribute("namespace");
            Namespace namespace = namespaceAttr != null ? Namespace.getNamespace(namespaceAttr) : NAMESPACE;
            DavPropertyName propName = DavPropertyName.create(nameAttr, namespace);
            DavProperty p = res.getProperty(propName);
            if (p != null) {
                if (p instanceof HrefProperty && res instanceof DeltaVResource) {
                    ElementIterator it = DomUtil.getChildren(propertyElem, "property", NAMESPACE);
                    resp.add(new ExpandProperty((DeltaVResource)res, (HrefProperty)p, it));
                    continue;
                }
                resp.add(p);
                continue;
            }
            resp.add(propName, 404);
        }
        return resp;
    }

    private class ExpandProperty
    extends AbstractDavProperty {
        private List valueList;

        private ExpandProperty(DeltaVResource deltaVResource, HrefProperty hrefProperty, ElementIterator elementIter) {
            super(hrefProperty.getName(), hrefProperty.isInvisibleInAllprop());
            this.valueList = new ArrayList();
            try {
                DavResource[] refResource = deltaVResource.getReferenceResources(hrefProperty.getName());
                int i = 0;
                while (i < refResource.length) {
                    MultiStatusResponse resp = ExpandPropertyReport.this.getResponse(refResource[i], elementIter);
                    this.valueList.add(resp);
                    ++i;
                }
            }
            catch (DavException e) {
                log.error(e.getMessage());
            }
        }

        public Object getValue() {
            return this.valueList;
        }
    }
}

