/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.webdav.version.report;

import java.util.List;
import org.apache.jackrabbit.webdav.DavConstants;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.DavResource;
import org.apache.jackrabbit.webdav.DavResourceLocator;
import org.apache.jackrabbit.webdav.property.HrefProperty;
import org.apache.jackrabbit.webdav.version.ActivityResource;
import org.apache.jackrabbit.webdav.version.DeltaVConstants;
import org.apache.jackrabbit.webdav.version.VersionHistoryResource;
import org.apache.jackrabbit.webdav.version.VersionResource;
import org.apache.jackrabbit.webdav.version.report.Report;
import org.apache.jackrabbit.webdav.version.report.ReportInfo;
import org.apache.jackrabbit.webdav.version.report.ReportType;
import org.apache.jackrabbit.webdav.xml.DomUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class LatestActivityVersionReport
implements Report {
    private static Logger log;
    private static final String XML_LATEST_ACTIVITY_VERSION = "latest-activity-version";
    private static final String XML_LATEST_ACTIVITY_VERSION_REPORT = "latest-activity-version-report";
    public static final ReportType LATEST_ACTIVITY_VERSION;
    private VersionHistoryResource vhResource;
    private DavResource activity;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.jackrabbit.webdav.version.report.LatestActivityVersionReport");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LoggerFactory.getLogger((Class)clazz);
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.apache.jackrabbit.webdav.version.report.LatestActivityVersionReport");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LATEST_ACTIVITY_VERSION = ReportType.register(XML_LATEST_ACTIVITY_VERSION, DeltaVConstants.NAMESPACE, clazz2);
    }

    public ReportType getType() {
        return LATEST_ACTIVITY_VERSION;
    }

    public boolean isMultiStatusReport() {
        return false;
    }

    public void init(DavResource resource, ReportInfo info) throws DavException {
        if (!this.getType().isRequestedReportType(info)) {
            throw new DavException(400, "DAV:latest-activity-version element expected.");
        }
        if (resource == null || !(resource instanceof VersionHistoryResource)) {
            throw new DavException(400, "DAV:latest-activity-version report can only be created for a version history resource.");
        }
        this.vhResource = (VersionHistoryResource)resource;
        String activityHref = DomUtil.getText(info.getContentElement("href", DavConstants.NAMESPACE));
        DavResourceLocator vhLocator = resource.getLocator();
        DavResourceLocator activityLocator = vhLocator.getFactory().createResourceLocator(vhLocator.getPrefix(), activityHref);
        this.activity = resource.getFactory().createResource(activityLocator, resource.getSession());
        if (!(this.activity instanceof ActivityResource)) {
            throw new DavException(400, "DAV:latest-activity-version report: The DAV:href in the request body MUST identify an activity.");
        }
    }

    public Element toXml(Document document) {
        String latestVersionHref = this.getLatestVersionHref();
        Element el = DomUtil.createElement(document, XML_LATEST_ACTIVITY_VERSION_REPORT, DeltaVConstants.NAMESPACE);
        el.appendChild(DomUtil.hrefToXml(latestVersionHref, document));
        return el;
    }

    private String getLatestVersionHref() {
        String latestVersionHref = "";
        try {
            List versionHrefs = new HrefProperty(this.activity.getProperty(ActivityResource.ACTIVITY_VERSION_SET)).getHrefs();
            VersionResource[] versions = this.vhResource.getVersions();
            int i = 0;
            while (i < versions.length) {
                VersionResource vr = versions[i];
                String href = vr.getHref();
                if (versionHrefs.contains(href)) {
                    if ("".equals(latestVersionHref)) {
                        latestVersionHref = href;
                    } else {
                        List predecessors = new HrefProperty(vr.getProperty(VersionResource.PREDECESSOR_SET)).getHrefs();
                        if (predecessors.contains(latestVersionHref)) {
                            latestVersionHref = href;
                        }
                    }
                }
                ++i;
            }
        }
        catch (DavException e) {
            log.error("Unexpected error while retrieving href of latest version.", (Throwable)e);
        }
        return latestVersionHref;
    }
}

