/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.webdav.version.report;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.jackrabbit.webdav.DavConstants;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.property.DavPropertyNameSet;
import org.apache.jackrabbit.webdav.version.report.ReportType;
import org.apache.jackrabbit.webdav.xml.DomUtil;
import org.apache.jackrabbit.webdav.xml.ElementIterator;
import org.apache.jackrabbit.webdav.xml.Namespace;
import org.apache.jackrabbit.webdav.xml.XmlSerializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ReportInfo
implements XmlSerializable {
    private static Logger log;
    private final String typeLocalName;
    private final Namespace typeNamespace;
    private final int depth;
    private final DavPropertyNameSet propertyNames;
    private final List content = new ArrayList();
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.jackrabbit.webdav.version.report.ReportInfo");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LoggerFactory.getLogger((Class)clazz);
    }

    public ReportInfo(ReportType type) {
        this(type, 0, null);
    }

    public ReportInfo(ReportType type, int depth) {
        this(type, depth, null);
    }

    public ReportInfo(ReportType type, int depth, DavPropertyNameSet propertyNames) {
        this.typeLocalName = type.getLocalName();
        this.typeNamespace = type.getNamespace();
        this.depth = depth;
        this.propertyNames = propertyNames != null ? new DavPropertyNameSet(propertyNames) : new DavPropertyNameSet();
    }

    public ReportInfo(Element reportElement, int depth) throws DavException {
        if (reportElement == null) {
            log.warn("Report request body must not be null.");
            throw new DavException(400);
        }
        this.typeLocalName = reportElement.getLocalName();
        this.typeNamespace = DomUtil.getNamespace(reportElement);
        this.depth = depth;
        Element propElement = DomUtil.getChildElement(reportElement, "prop", DavConstants.NAMESPACE);
        if (propElement != null) {
            this.propertyNames = new DavPropertyNameSet(propElement);
            reportElement.removeChild(propElement);
        } else {
            this.propertyNames = new DavPropertyNameSet();
        }
        ElementIterator it = DomUtil.getChildren(reportElement);
        while (it.hasNext()) {
            Element el = it.nextElement();
            if ("prop".equals(el.getLocalName())) continue;
            this.content.add(el);
        }
    }

    public int getDepth() {
        return this.depth;
    }

    public String getReportName() {
        return DomUtil.getQualifiedName(this.typeLocalName, this.typeNamespace);
    }

    public boolean containsContentElement(String localName, Namespace namespace) {
        if (this.content.isEmpty()) {
            return false;
        }
        Iterator it = this.content.iterator();
        while (it.hasNext()) {
            boolean sameNamespace;
            Element elem = (Element)it.next();
            boolean bl = namespace == null ? elem.getNamespaceURI() == null : (sameNamespace = namespace.isSame(elem.getNamespaceURI()));
            if (!sameNamespace || !elem.getLocalName().equals(localName)) continue;
            return true;
        }
        return false;
    }

    public Element getContentElement(String localName, Namespace namespace) {
        List values = this.getContentElements(localName, namespace);
        if (values.isEmpty()) {
            return null;
        }
        return (Element)values.get(0);
    }

    public List getContentElements(String localName, Namespace namespace) {
        ArrayList<Element> l = new ArrayList<Element>();
        Iterator it = this.content.iterator();
        while (it.hasNext()) {
            Element elem = (Element)it.next();
            if (!DomUtil.matches(elem, localName, namespace)) continue;
            l.add(elem);
        }
        return l;
    }

    public void setContentElement(Element contentElement) {
        this.content.add(contentElement);
    }

    public DavPropertyNameSet getPropertyNameSet() {
        return this.propertyNames;
    }

    public Element toXml(Document document) {
        Element reportElement = DomUtil.createElement(document, this.typeLocalName, this.typeNamespace);
        if (!this.content.isEmpty()) {
            Iterator it = this.content.iterator();
            while (it.hasNext()) {
                Object contentEntry = it.next();
                if (!(contentEntry instanceof Node)) continue;
                Node n = document.importNode((Node)contentEntry, true);
                reportElement.appendChild(n);
            }
        }
        if (!this.propertyNames.isEmpty()) {
            reportElement.appendChild(this.propertyNames.toXml(document));
        }
        return reportElement;
    }
}

