/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.webdav.xml;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.jackrabbit.webdav.xml.DomUtil;
import org.apache.jackrabbit.webdav.xml.Namespace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ElementIterator
implements Iterator {
    private static Logger log;
    private final Namespace namespace;
    private final String localName;
    private Element next;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.jackrabbit.webdav.xml.ElementIterator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LoggerFactory.getLogger((Class)clazz);
    }

    public ElementIterator(Element parent, String localName, Namespace namespace) {
        this.localName = localName;
        this.namespace = namespace;
        this.seek(parent);
    }

    public ElementIterator(Element parent) {
        this(parent, null, null);
    }

    public void remove() {
        throw new UnsupportedOperationException("Remove not implemented.");
    }

    public boolean hasNext() {
        return this.next != null;
    }

    public Object next() {
        return this.nextElement();
    }

    public Element nextElement() {
        if (this.next == null) {
            throw new NoSuchElementException();
        }
        Element ret = this.next;
        this.seek();
        return ret;
    }

    private void seek(Element parent) {
        NodeList nodeList = parent.getChildNodes();
        int i = 0;
        while (i < nodeList.getLength()) {
            Node n = nodeList.item(i);
            if (DomUtil.isElement(n) && DomUtil.matches(n, this.localName, this.namespace)) {
                this.next = (Element)n;
                return;
            }
            ++i;
        }
    }

    private void seek() {
        Node n = this.next.getNextSibling();
        while (n != null) {
            if (DomUtil.isElement(n) && DomUtil.matches(n, this.localName, this.namespace)) {
                this.next = (Element)n;
                return;
            }
            n = n.getNextSibling();
        }
        this.next = null;
    }
}

