/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.webdav.client.methods;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.httpclient.HttpConnection;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.methods.EntityEnclosingMethod;
import org.apache.jackrabbit.webdav.DavConstants;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.MultiStatus;
import org.apache.jackrabbit.webdav.client.methods.DavMethod;
import org.apache.jackrabbit.webdav.client.methods.XmlRequestEntity;
import org.apache.jackrabbit.webdav.header.Header;
import org.apache.jackrabbit.webdav.xml.DomUtil;
import org.apache.jackrabbit.webdav.xml.XmlSerializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class DavMethodBase
extends EntityEnclosingMethod
implements DavMethod,
DavConstants {
    private static Logger log = LoggerFactory.getLogger(DavMethodBase.class);
    static final DocumentBuilderFactory BUILDER_FACTORY = DomUtil.BUILDER_FACTORY;
    private boolean success;
    private Document responseDocument;
    private MultiStatus multiStatus;

    public DavMethodBase(String uri) {
        super(uri);
    }

    public abstract String getName();

    public void addRequestHeader(Header header) {
        this.addRequestHeader(header.getHeaderName(), header.getHeaderValue());
    }

    public void setRequestHeader(Header header) {
        this.setRequestHeader(header.getHeaderName(), header.getHeaderValue());
    }

    public MultiStatus getResponseBodyAsMultiStatus() throws IOException, DavException {
        this.checkUsed();
        if (this.multiStatus != null) {
            return this.multiStatus;
        }
        DavException dx = this.getResponseException();
        if (dx != null) {
            throw dx;
        }
        throw new DavException(this.getStatusCode(), this.getName() + " resulted with unexpected status: " + this.getStatusLine());
    }

    public Document getResponseBodyAsDocument() throws IOException {
        if (this.responseDocument != null) {
            return this.responseDocument;
        }
        InputStream in = this.getResponseBodyAsStream();
        if (in != null) {
            try {
                DocumentBuilder docBuilder = BUILDER_FACTORY.newDocumentBuilder();
                docBuilder.setErrorHandler(new DefaultHandler());
                Document document = this.responseDocument = docBuilder.parse(in);
                return document;
            }
            catch (ParserConfigurationException e) {
                IOException exception = new IOException("XML parser configuration error");
                exception.initCause(e);
                throw exception;
            }
            catch (SAXException e) {
                IOException exception = new IOException("XML parsing error");
                exception.initCause(e);
                throw exception;
            }
            finally {
                in.close();
            }
        }
        return null;
    }

    Element getRootElement() throws IOException {
        Document document = this.getResponseBodyAsDocument();
        if (document != null) {
            return document.getDocumentElement();
        }
        return null;
    }

    public DavException getResponseException() throws IOException {
        this.checkUsed();
        if (this.success) {
            String msg = "Cannot retrieve exception from successful response.";
            log.warn(msg);
            throw new IllegalStateException(msg);
        }
        Element responseRoot = null;
        try {
            responseRoot = this.getRootElement();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (responseRoot != null) {
            return new DavException(this.getStatusCode(), this.getStatusText(), null, responseRoot);
        }
        return new DavException(this.getStatusCode(), this.getStatusText());
    }

    public void checkSuccess() throws DavException, IOException {
        if (!this.succeeded()) {
            throw this.getResponseException();
        }
    }

    public boolean succeeded() {
        this.checkUsed();
        return this.success;
    }

    public void setRequestBody(Document requestBody) throws IOException {
        this.setRequestEntity(new XmlRequestEntity(requestBody));
    }

    public void setRequestBody(XmlSerializable requestBody) throws IOException {
        try {
            Document doc = BUILDER_FACTORY.newDocumentBuilder().newDocument();
            doc.appendChild(requestBody.toXml(doc));
            this.setRequestBody(doc);
        }
        catch (ParserConfigurationException e) {
            IOException exception = new IOException("XML parser configuration error");
            exception.initCause(e);
            throw exception;
        }
    }

    protected abstract boolean isSuccess(int var1);

    protected void setSuccess(boolean success) {
        this.success = success;
    }

    protected boolean getSuccess() {
        return this.success;
    }

    protected void processMultiStatusBody(MultiStatus multiStatus, HttpState httpState, HttpConnection httpConnection) {
    }

    protected void processStatusLine(HttpState httpState, HttpConnection httpConnection) {
        super.processStatusLine(httpState, httpConnection);
        int code = this.getStatusCode();
        this.success = this.isSuccess(code);
    }

    protected void processResponseBody(HttpState httpState, HttpConnection httpConnection) {
        if (this.getStatusCode() == 207) {
            try {
                this.multiStatus = MultiStatus.createFromXml(this.getRootElement());
                this.processMultiStatusBody(this.multiStatus, httpState, httpConnection);
            }
            catch (IOException e) {
                log.error("Error while parsing multistatus response: " + e);
                this.success = false;
            }
        }
    }
}

