/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.webdav.client.methods;

import java.io.IOException;
import java.util.List;
import org.apache.commons.httpclient.HttpConnection;
import org.apache.commons.httpclient.HttpState;
import org.apache.jackrabbit.webdav.DavConstants;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.MultiStatus;
import org.apache.jackrabbit.webdav.MultiStatusResponse;
import org.apache.jackrabbit.webdav.Status;
import org.apache.jackrabbit.webdav.client.methods.DavMethodBase;
import org.apache.jackrabbit.webdav.property.DavPropertyName;
import org.apache.jackrabbit.webdav.property.DavPropertyNameIterator;
import org.apache.jackrabbit.webdav.property.DavPropertyNameSet;
import org.apache.jackrabbit.webdav.property.DavPropertySet;
import org.apache.jackrabbit.webdav.property.PropEntry;
import org.apache.jackrabbit.webdav.property.ProppatchInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class PropPatchMethod
extends DavMethodBase
implements DavConstants {
    private static Logger log = LoggerFactory.getLogger(PropPatchMethod.class);
    private DavException responseException;
    private DavPropertyNameSet propertyNames;

    public PropPatchMethod(String uri, List<? extends PropEntry> changeList) throws IOException {
        super(uri);
        ProppatchInfo info = new ProppatchInfo(changeList);
        this.setRequestBody(info);
        this.propertyNames = info.getAffectedProperties();
    }

    public PropPatchMethod(String uri, DavPropertySet setProperties, DavPropertyNameSet removeProperties) throws IOException {
        super(uri);
        ProppatchInfo info = new ProppatchInfo(setProperties, removeProperties);
        this.setRequestBody(info);
        this.propertyNames = info.getAffectedProperties();
    }

    @Override
    public String getName() {
        return "PROPPATCH";
    }

    @Override
    protected boolean isSuccess(int statusCode) {
        return statusCode == 207 || statusCode == 200;
    }

    @Override
    protected void processMultiStatusBody(MultiStatus multiStatus, HttpState httpState, HttpConnection httpConnection) {
        MultiStatusResponse[] resp = multiStatus.getResponses();
        if (resp.length != 1) {
            log.warn("Expected a single multi-status response in PROPPATCH, but got " + resp.length + " elements.");
        }
        boolean success = true;
        if (resp.length == 1) {
            MultiStatusResponse r = resp[0];
            if (r.isPropStat()) {
                DavPropertyNameSet okSet = r.getPropertyNames(200);
                if (okSet.isEmpty()) {
                    log.debug("PROPPATCH failed: No 'OK' response found for resource " + r.getHref());
                    success = false;
                } else {
                    DavPropertyNameIterator it = this.propertyNames.iterator();
                    while (it.hasNext()) {
                        DavPropertyName pn = it.nextPropertyName();
                        success = okSet.remove(pn);
                    }
                }
                if (!okSet.isEmpty()) {
                    StringBuffer b = new StringBuffer("The following properties outside of the original request where set or removed: ");
                    DavPropertyNameIterator it = okSet.iterator();
                    while (it.hasNext()) {
                        b.append(it.nextPropertyName().toString()).append("; ");
                    }
                    log.warn(b.toString());
                }
            } else {
                int status = r.getStatus()[0].getStatusCode();
                boolean bl = success = status == 200;
                if (!success) {
                    log.warn("PROPPATCH failed: overall status of " + status);
                }
            }
        }
        if (!success) {
            Status[] st = resp[0].getStatus();
            block5: for (int i = 0; i < st.length && this.responseException == null; ++i) {
                switch (st[i].getStatusCode()) {
                    case 424: {
                        continue block5;
                    }
                    default: {
                        this.responseException = new DavException(st[i].getStatusCode());
                    }
                }
            }
        }
    }

    @Override
    public DavException getResponseException() throws IOException {
        this.checkUsed();
        if (this.getSuccess()) {
            String msg = "Cannot retrieve exception from successful response.";
            log.warn(msg);
            throw new IllegalStateException(msg);
        }
        if (this.responseException != null) {
            return this.responseException;
        }
        return super.getResponseException();
    }
}

