/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.webdav.io;

import java.io.InputStream;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import org.apache.jackrabbit.webdav.io.InputContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InputContextImpl
implements InputContext {
    private static Logger log = LoggerFactory.getLogger(InputContextImpl.class);
    private final HttpServletRequest request;
    private final InputStream in;

    public InputContextImpl(HttpServletRequest request, InputStream in) {
        if (request == null) {
            throw new IllegalArgumentException("DavResource and Request must not be null.");
        }
        this.request = request;
        this.in = in;
    }

    public boolean hasStream() {
        return this.in != null;
    }

    public InputStream getInputStream() {
        return this.in;
    }

    public long getModificationTime() {
        return new Date().getTime();
    }

    public String getContentLanguage() {
        return this.request.getHeader("Content-Language");
    }

    public long getContentLength() {
        String length = this.request.getHeader("Content-Length");
        if (length == null) {
            return -1L;
        }
        try {
            return Long.parseLong(length);
        }
        catch (NumberFormatException ex) {
            log.error("broken Content-Length header: " + length);
            return -1L;
        }
    }

    public String getContentType() {
        return this.request.getHeader("Content-Type");
    }

    public String getProperty(String propertyName) {
        return this.request.getHeader(propertyName);
    }
}

