/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.authentication.external.impl.jmx;

import org.apache.jackrabbit.oak.spi.security.authentication.external.ExternalIdentityRef;
import org.apache.jackrabbit.oak.spi.security.authentication.external.SyncResult;
import org.apache.jackrabbit.oak.spi.security.authentication.external.SyncedIdentity;
import org.apache.jackrabbit.oak.spi.security.authentication.external.basic.DefaultSyncedIdentity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ErrorSyncResult
implements SyncResult {
    private final SyncedIdentity syncedIdentity;
    private final Exception error;

    ErrorSyncResult(@NotNull String userId, @Nullable String idpName, @NotNull Exception error) {
        ExternalIdentityRef ref = idpName != null ? new ExternalIdentityRef(userId, idpName) : null;
        this.syncedIdentity = new DefaultSyncedIdentity(userId, ref, false, -1L);
        this.error = error;
    }

    ErrorSyncResult(@NotNull ExternalIdentityRef ref, @NotNull Exception error) {
        this.syncedIdentity = new DefaultSyncedIdentity(ref.getId(), ref, false, -1L);
        this.error = error;
    }

    @Override
    @NotNull
    public SyncedIdentity getIdentity() {
        return this.syncedIdentity;
    }

    @Override
    @NotNull
    public SyncResult.Status getStatus() {
        return SyncResult.Status.NOP;
    }

    Exception getException() {
        return this.error;
    }
}

