/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.authentication.external.impl.principal;

import java.security.Principal;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.jackrabbit.api.security.principal.PrincipalManager;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.spi.commit.MoveTracker;
import org.apache.jackrabbit.oak.spi.commit.ThreeWayConflictHandler;
import org.apache.jackrabbit.oak.spi.commit.ValidatorProvider;
import org.apache.jackrabbit.oak.spi.lifecycle.RepositoryInitializer;
import org.apache.jackrabbit.oak.spi.security.ConfigurationBase;
import org.apache.jackrabbit.oak.spi.security.ConfigurationParameters;
import org.apache.jackrabbit.oak.spi.security.SecurityConfiguration;
import org.apache.jackrabbit.oak.spi.security.SecurityProvider;
import org.apache.jackrabbit.oak.spi.security.authentication.external.impl.principal.ExternalGroupPrincipalProvider;
import org.apache.jackrabbit.oak.spi.security.authentication.external.impl.principal.ExternalIdentityConflictHandler;
import org.apache.jackrabbit.oak.spi.security.authentication.external.impl.principal.ExternalIdentityImporter;
import org.apache.jackrabbit.oak.spi.security.authentication.external.impl.principal.ExternalIdentityRepositoryInitializer;
import org.apache.jackrabbit.oak.spi.security.authentication.external.impl.principal.ExternalIdentityValidatorProvider;
import org.apache.jackrabbit.oak.spi.security.authentication.external.impl.principal.SyncConfigTracker;
import org.apache.jackrabbit.oak.spi.security.authentication.external.impl.principal.SyncHandlerMappingTracker;
import org.apache.jackrabbit.oak.spi.security.principal.EmptyPrincipalProvider;
import org.apache.jackrabbit.oak.spi.security.principal.PrincipalConfiguration;
import org.apache.jackrabbit.oak.spi.security.principal.PrincipalManagerImpl;
import org.apache.jackrabbit.oak.spi.security.principal.PrincipalProvider;
import org.apache.jackrabbit.oak.spi.security.user.UserConfiguration;
import org.apache.jackrabbit.oak.spi.xml.ProtectedItemImporter;
import org.jetbrains.annotations.NotNull;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=true, label="Apache Jackrabbit Oak External PrincipalConfiguration", immediate=true)
@Service(value={PrincipalConfiguration.class, SecurityConfiguration.class})
@Properties(value={@Property(name="protectExternalId", label="External Identity Protection", description="If disabled rep:externalId properties won't be properly protected (backwards compatible behavior). NOTE: for security reasons it is strongly recommend to keep the protection enabled!", boolValue={true}), @Property(name="oak.security.name", propertyPrivate=true, value={"org.apache.jackrabbit.oak.spi.security.authentication.external.impl.principal.ExternalPrincipalConfiguration"})})
public class ExternalPrincipalConfiguration
extends ConfigurationBase
implements PrincipalConfiguration {
    private static final Logger log = LoggerFactory.getLogger(ExternalPrincipalConfiguration.class);
    private SyncConfigTracker syncConfigTracker;
    private SyncHandlerMappingTracker syncHandlerMappingTracker;

    public ExternalPrincipalConfiguration() {
    }

    public ExternalPrincipalConfiguration(SecurityProvider securityProvider) {
        super(securityProvider, securityProvider.getParameters("org.apache.jackrabbit.oak.principal"));
    }

    @NotNull
    public PrincipalManager getPrincipalManager(Root root, NamePathMapper namePathMapper) {
        return new PrincipalManagerImpl(this.getPrincipalProvider(root, namePathMapper));
    }

    @NotNull
    public PrincipalProvider getPrincipalProvider(Root root, NamePathMapper namePathMapper) {
        if (this.dynamicMembershipEnabled()) {
            UserConfiguration uc = (UserConfiguration)this.getSecurityProvider().getConfiguration(UserConfiguration.class);
            return new ExternalGroupPrincipalProvider(root, uc, namePathMapper, this.syncConfigTracker.getAutoMembership());
        }
        return EmptyPrincipalProvider.INSTANCE;
    }

    @NotNull
    public String getName() {
        return "org.apache.jackrabbit.oak.principal";
    }

    @NotNull
    public RepositoryInitializer getRepositoryInitializer() {
        return new ExternalIdentityRepositoryInitializer(this.protectedExternalIds());
    }

    @NotNull
    public List<? extends ValidatorProvider> getValidators(@NotNull String workspaceName, @NotNull Set<Principal> principals, @NotNull MoveTracker moveTracker) {
        return Collections.singletonList(new ExternalIdentityValidatorProvider(principals, this.protectedExternalIds()));
    }

    @NotNull
    public List<ProtectedItemImporter> getProtectedItemImporters() {
        return Collections.singletonList(new ExternalIdentityImporter());
    }

    @NotNull
    public List<ThreeWayConflictHandler> getConflictHandlers() {
        return Collections.singletonList(new ExternalIdentityConflictHandler());
    }

    @Activate
    private void activate(BundleContext bundleContext, Map<String, Object> properties) {
        this.setParameters(ConfigurationParameters.of(properties));
        this.syncHandlerMappingTracker = new SyncHandlerMappingTracker(bundleContext);
        this.syncHandlerMappingTracker.open();
        this.syncConfigTracker = new SyncConfigTracker(bundleContext, this.syncHandlerMappingTracker);
        this.syncConfigTracker.open();
    }

    @Deactivate
    private void deactivate() {
        if (this.syncConfigTracker != null) {
            this.syncConfigTracker.close();
        }
        if (this.syncHandlerMappingTracker != null) {
            this.syncHandlerMappingTracker.close();
        }
    }

    private boolean dynamicMembershipEnabled() {
        return this.syncConfigTracker != null && this.syncConfigTracker.isEnabled();
    }

    private boolean protectedExternalIds() {
        return (Boolean)this.getParameters().getConfigValue("protectExternalId", (Object)true);
    }
}

