/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.authentication.external.impl.jmx;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterators;
import java.io.IOException;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.jcr.RepositoryException;
import javax.jcr.ValueFactory;
import javax.security.auth.Subject;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.api.ContentRepository;
import org.apache.jackrabbit.oak.api.ContentSession;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.plugins.value.jcr.ValueFactoryImpl;
import org.apache.jackrabbit.oak.spi.security.SecurityProvider;
import org.apache.jackrabbit.oak.spi.security.authentication.SystemSubject;
import org.apache.jackrabbit.oak.spi.security.authentication.external.ExternalIdentity;
import org.apache.jackrabbit.oak.spi.security.authentication.external.ExternalIdentityException;
import org.apache.jackrabbit.oak.spi.security.authentication.external.ExternalIdentityProvider;
import org.apache.jackrabbit.oak.spi.security.authentication.external.ExternalIdentityRef;
import org.apache.jackrabbit.oak.spi.security.authentication.external.ExternalUser;
import org.apache.jackrabbit.oak.spi.security.authentication.external.SyncContext;
import org.apache.jackrabbit.oak.spi.security.authentication.external.SyncException;
import org.apache.jackrabbit.oak.spi.security.authentication.external.SyncHandler;
import org.apache.jackrabbit.oak.spi.security.authentication.external.SyncResult;
import org.apache.jackrabbit.oak.spi.security.authentication.external.SyncedIdentity;
import org.apache.jackrabbit.oak.spi.security.authentication.external.basic.DefaultSyncResultImpl;
import org.apache.jackrabbit.oak.spi.security.authentication.external.basic.DefaultSyncedIdentity;
import org.apache.jackrabbit.oak.spi.security.authentication.external.impl.jmx.ErrorSyncResult;
import org.apache.jackrabbit.oak.spi.security.authentication.external.impl.jmx.ResultMessages;
import org.apache.jackrabbit.oak.spi.security.authentication.external.impl.jmx.SyncRuntimeException;
import org.apache.jackrabbit.oak.spi.security.user.UserConfiguration;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class Delegatee {
    private static final Logger log = LoggerFactory.getLogger(Delegatee.class);
    private static final String ERROR_CREATE_DELEGATEE = "Unable to create delegatee";
    private static final String ERROR_SYNC_USER = "Error while syncing user {}";
    private static final int NO_BATCH_SIZE = 0;
    private static final int DEFAULT_BATCH_SIZE = 100;
    private final SyncHandler handler;
    private final ExternalIdentityProvider idp;
    private final UserManager userMgr;
    private final ContentSession systemSession;
    private final Root root;
    private final int batchSize;
    private SyncContext context;

    private Delegatee(@NotNull SyncHandler handler, @NotNull ExternalIdentityProvider idp, @NotNull ContentSession systemSession, @NotNull SecurityProvider securityProvider, int batchSize) {
        this.handler = handler;
        this.idp = idp;
        this.systemSession = systemSession;
        this.batchSize = batchSize;
        this.root = systemSession.getLatestRoot();
        this.userMgr = ((UserConfiguration)securityProvider.getConfiguration(UserConfiguration.class)).getUserManager(this.root, NamePathMapper.DEFAULT);
        this.context = handler.createContext(idp, this.userMgr, (ValueFactory)new ValueFactoryImpl(this.root, NamePathMapper.DEFAULT));
        log.info("Created delegatee for SyncMBean with session: {} {}", (Object)systemSession, (Object)systemSession.getAuthInfo().getUserID());
    }

    @NotNull
    static Delegatee createInstance(@NotNull ContentRepository repository, @NotNull SecurityProvider securityProvider, @NotNull SyncHandler handler, @NotNull ExternalIdentityProvider idp) {
        return Delegatee.createInstance(repository, securityProvider, handler, idp, 100);
    }

    @NotNull
    static Delegatee createInstance(@NotNull ContentRepository repository, @NotNull SecurityProvider securityProvider, @NotNull SyncHandler handler, @NotNull ExternalIdentityProvider idp, int batchSize) {
        ContentSession systemSession;
        try {
            systemSession = Subject.doAs(SystemSubject.INSTANCE, () -> repository.login(null, null));
        }
        catch (PrivilegedActionException e) {
            throw new SyncRuntimeException(ERROR_CREATE_DELEGATEE, e);
        }
        return new Delegatee(handler, idp, systemSession, securityProvider, batchSize);
    }

    private static void close(@NotNull ContentSession systemSession) {
        try {
            systemSession.close();
        }
        catch (IOException e) {
            log.error("Error while closing ContentSession {}", (Object)systemSession);
        }
    }

    void close() {
        if (this.context != null) {
            this.context.close();
            this.context = null;
        }
        Delegatee.close(this.systemSession);
    }

    @NotNull
    String[] syncUsers(@NotNull String[] userIds, boolean purge) {
        this.context.setKeepMissing(!purge).setForceGroupSync(true).setForceUserSync(true);
        ResultMessages messages = new ResultMessages();
        List<SyncResult> results = new ArrayList<SyncResult>(this.batchSize);
        for (String userId : userIds) {
            results = this.syncUser(userId, false, results, messages);
        }
        this.commit(messages, results, 0);
        return messages.getMessages();
    }

    @NotNull
    String[] syncAllUsers(boolean purge) {
        try {
            ResultMessages messages = new ResultMessages();
            this.context.setKeepMissing(!purge).setForceGroupSync(true).setForceUserSync(true);
            Iterator<SyncedIdentity> it = this.handler.listIdentities(this.userMgr);
            List<SyncResult> results = new ArrayList<SyncResult>(this.batchSize);
            while (it.hasNext()) {
                SyncedIdentity id = it.next();
                if (!this.isMyIDP(id)) continue;
                results = this.syncUser(id.getId(), false, results, messages);
            }
            this.commit(messages, results, 0);
            return messages.getMessages();
        }
        catch (RepositoryException e) {
            throw new IllegalStateException("Error retrieving users for syncing", e);
        }
    }

    @NotNull
    String[] syncExternalUsers(@NotNull String[] externalIds) {
        ResultMessages messages = new ResultMessages();
        this.context.setForceGroupSync(true).setForceUserSync(true);
        List<SyncResult> results = new ArrayList<SyncResult>(this.batchSize);
        for (String externalId : externalIds) {
            ExternalIdentityRef ref = ExternalIdentityRef.fromString(externalId);
            if (!this.idp.getName().equals(ref.getProviderName())) {
                results.add(new DefaultSyncResultImpl(new DefaultSyncedIdentity(ref.getId(), ref, false, -1L), SyncResult.Status.FOREIGN));
                continue;
            }
            try {
                ExternalIdentity id = this.idp.getIdentity(ref);
                if (id != null) {
                    results = this.syncUser(id, results, messages);
                    continue;
                }
                results.add(new DefaultSyncResultImpl(new DefaultSyncedIdentity("", ref, false, -1L), SyncResult.Status.NO_SUCH_IDENTITY));
            }
            catch (ExternalIdentityException e) {
                log.warn("error while fetching the external identity {}", (Object)externalId, (Object)e);
                results.add(new ErrorSyncResult(ref, e));
            }
        }
        this.commit(messages, results, 0);
        return messages.getMessages();
    }

    @NotNull
    String[] syncAllExternalUsers() {
        ResultMessages messages = new ResultMessages();
        this.context.setForceGroupSync(true).setForceUserSync(true);
        try {
            List<SyncResult> results = new ArrayList<SyncResult>(this.batchSize);
            Iterator<ExternalUser> it = this.idp.listUsers();
            while (it.hasNext()) {
                ExternalUser user = it.next();
                results = this.syncUser(user, results, messages);
            }
            this.commit(messages, results, 0);
            return messages.getMessages();
        }
        catch (ExternalIdentityException e) {
            throw new SyncRuntimeException("Unable to retrieve external users", e);
        }
    }

    @NotNull
    String[] listOrphanedUsers() {
        return (String[])Iterators.toArray(this.internalListOrphanedIdentities(), String.class);
    }

    @NotNull
    String[] purgeOrphanedUsers() {
        this.context.setKeepMissing(false);
        ResultMessages messages = new ResultMessages();
        Iterator<String> orphanedIdentities = this.internalListOrphanedIdentities();
        List<SyncResult> results = new ArrayList<SyncResult>(this.batchSize);
        while (orphanedIdentities.hasNext()) {
            String userId = orphanedIdentities.next();
            results = this.syncUser(userId, true, results, messages);
        }
        this.commit(messages, results, 0);
        return messages.getMessages();
    }

    private boolean isMyIDP(@NotNull SyncedIdentity id) {
        ExternalIdentityRef ref = id.getExternalIdRef();
        String providerName = ref == null ? null : ref.getProviderName();
        return providerName != null && providerName.equals(this.idp.getName());
    }

    @NotNull
    private List<SyncResult> syncUser(@NotNull ExternalIdentity id, @NotNull List<SyncResult> results, @NotNull ResultMessages messages) {
        try {
            SyncResult r = this.context.sync(id);
            if (r.getIdentity() == null) {
                r = new DefaultSyncResultImpl(new DefaultSyncedIdentity(id.getId(), id.getExternalId(), false, -1L), SyncResult.Status.NO_SUCH_IDENTITY);
                log.warn("sync failed. {}", (Object)r.getIdentity());
            } else {
                log.info("synced {}", (Object)r.getIdentity());
            }
            results.add(r);
        }
        catch (SyncException e) {
            log.error(ERROR_SYNC_USER, (Object)id, (Object)e);
            results.add(new ErrorSyncResult(id.getExternalId(), e));
        }
        return this.commit(messages, results, this.batchSize);
    }

    @NotNull
    private List<SyncResult> syncUser(@NotNull String userId, boolean includeIdpName, @NotNull List<SyncResult> results, @NotNull ResultMessages messages) {
        try {
            results.add(this.context.sync(userId));
        }
        catch (SyncException e) {
            log.warn(ERROR_SYNC_USER, (Object)userId, (Object)e);
            results.add(new ErrorSyncResult(userId, includeIdpName ? this.idp.getName() : null, e));
        }
        return this.commit(messages, results, this.batchSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private List<SyncResult> commit(@NotNull ResultMessages messages, @NotNull List<SyncResult> resultList, int size) {
        if (resultList.isEmpty() || resultList.size() < size) {
            return resultList;
        }
        try {
            this.root.commit();
            messages.append(resultList);
        }
        catch (CommitFailedException e) {
            messages.append(resultList, (Exception)((Object)e));
        }
        finally {
            this.root.refresh();
        }
        return new ArrayList<SyncResult>(size);
    }

    @NotNull
    private Iterator<String> internalListOrphanedIdentities() {
        try {
            Iterator<SyncedIdentity> it = this.handler.listIdentities(this.userMgr);
            return Iterators.filter((Iterator)Iterators.transform(it, syncedIdentity -> {
                if (syncedIdentity != null && this.isMyIDP((SyncedIdentity)syncedIdentity)) {
                    try {
                        ExternalIdentity extId = this.idp.getIdentity((ExternalIdentityRef)Preconditions.checkNotNull((Object)syncedIdentity.getExternalIdRef()));
                        if (extId == null) {
                            return syncedIdentity.getId();
                        }
                    }
                    catch (ExternalIdentityException e) {
                        log.error("Error while fetching external identity {}", syncedIdentity, (Object)e);
                    }
                }
                return null;
            }), (Predicate)Predicates.notNull());
        }
        catch (RepositoryException e) {
            log.error("Error while listing orphaned users", (Throwable)e);
            return Collections.emptyIterator();
        }
    }
}

