/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.authentication.external.impl;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.jackrabbit.oak.spi.security.ConfigurationParameters;
import org.apache.jackrabbit.oak.spi.security.authentication.external.basic.DefaultSyncConfig;

@Component(label="Apache Jackrabbit Oak Default Sync Handler", name="org.apache.jackrabbit.oak.spi.security.authentication.external.impl.DefaultSyncHandler", configurationFactory=true, metatype=true, ds=false)
public class DefaultSyncConfigImpl
extends DefaultSyncConfig {
    public static final String PARAM_NAME_DEFAULT = "default";
    @Property(label="Sync Handler Name", description="Name of this sync configuration. This is used to reference this handler by the login modules.", value={"default"})
    public static final String PARAM_NAME = "handler.name";
    public static final String PARAM_USER_EXPIRATION_TIME_DEFAULT = "1h";
    @Property(label="User Expiration Time", description="Duration until a synced user gets expired (eg. '1h 30m' or '1d').", value={"1h"})
    public static final String PARAM_USER_EXPIRATION_TIME = "user.expirationTime";
    public static final String[] PARAM_USER_AUTO_MEMBERSHIP_DEFAULT = new String[0];
    @Property(label="User auto membership", description="List of groups that a synced user is added to automatically", value={}, cardinality=0x7FFFFFFF)
    public static final String PARAM_USER_AUTO_MEMBERSHIP = "user.autoMembership";
    public static final String[] PARAM_USER_PROPERTY_MAPPING_DEFAULT = new String[]{"rep:fullname=cn"};
    @Property(label="User property mapping", description="List mapping definition of local properties from external ones. eg: 'profile/email=mail'.Use double quotes for fixed values. eg: 'profile/nt:primaryType=\"nt:unstructured\"", value={"rep:fullname=cn"}, cardinality=0x7FFFFFFF)
    public static final String PARAM_USER_PROPERTY_MAPPING = "user.propertyMapping";
    public static final String PARAM_USER_PATH_PREFIX_DEFAULT = "";
    @Property(label="User Path Prefix", description="The path prefix used when creating new users.", value={""})
    public static final String PARAM_USER_PATH_PREFIX = "user.pathPrefix";
    public static final String PARAM_USER_MEMBERSHIP_EXPIRATION_TIME_DEFAULT = "1h";
    @Property(label="User Membership Expiration", description="Time after which membership expires (eg. '1h 30m' or '1d'). Note however, that a membership sync is aways bound to a sync of the user.", value={"1h"})
    public static final String PARAM_USER_MEMBERSHIP_EXPIRATION_TIME = "user.membershipExpTime";
    public static final int PARAM_USER_MEMBERSHIP_NESTING_DEPTH_DEFAULT = 0;
    @Property(label="User membership nesting depth", description="Returns the maximum depth of group nesting when membership relations are synced. A value of 0 effectively disables group membership lookup. A value of 1 only adds the direct groups of a user. This value has no effect when syncing individual groups only when syncing a users membership ancestry.", intValue={0})
    public static final String PARAM_USER_MEMBERSHIP_NESTING_DEPTH = "user.membershipNestingDepth";
    public static final boolean PARAM_USER_DYNAMIC_MEMBERSHIP_DEFAULT = false;
    @Property(label="User Dynamic Membership", description="If enabled membership of external identities (user) is no longer fully reflected within the repositories user management.", boolValue={false})
    public static final String PARAM_USER_DYNAMIC_MEMBERSHIP = "user.dynamicMembership";
    public static final boolean PARAM_DISABLE_MISSING_USERS_DEFAULT = false;
    @Property(label="Disable missing users", description="If true, users that no longer exist on the external provider will be locally disabled, and re-enabled if they become valid again. If false (default) they will be removed.", boolValue={false})
    public static final String PARAM_DISABLE_MISSING_USERS = "user.disableMissing";
    public static final String PARAM_GROUP_EXPIRATION_TIME_DEFAULT = "1d";
    @Property(label="Group Expiration Time", description="Duration until a synced group expires (eg. '1h 30m' or '1d').", value={"1d"})
    public static final String PARAM_GROUP_EXPIRATION_TIME = "group.expirationTime";
    public static final String[] PARAM_GROUP_AUTO_MEMBERSHIP_DEFAULT = new String[0];
    @Property(label="Group auto membership", description="List of groups that a synced group is added to automatically", value={}, cardinality=0x7FFFFFFF)
    public static final String PARAM_GROUP_AUTO_MEMBERSHIP = "group.autoMembership";
    public static final String[] PARAM_GROUP_PROPERTY_MAPPING_DEFAULT = new String[0];
    @Property(label="Group property mapping", description="List mapping definition of local properties from external ones.", value={}, cardinality=0x7FFFFFFF)
    public static final String PARAM_GROUP_PROPERTY_MAPPING = "group.propertyMapping";
    public static final String PARAM_GROUP_PATH_PREFIX_DEFAULT = "";
    @Property(label="Group Path Prefix", description="The path prefix used when creating new groups.", value={""})
    public static final String PARAM_GROUP_PATH_PREFIX = "group.pathPrefix";
    public static final boolean PARAM_ENABLE_RFC7613_USERCASE_MAPPED_PROFILE_DEFAULT = false;
    @Property(label="RFC7613 Username Normalization Profile", description="Enable the UsercaseMappedProfile defined in RFC7613 for username normalization.", boolValue={false})
    public static final String PARAM_ENABLE_RFC7613_USERCASE_MAPPED_PROFILE = "enableRFC7613UsercaseMappedProfile";
    private static final long MILLIS_PER_HOUR = 3600000L;
    private static final ConfigurationParameters.Milliseconds ONE_HOUR = ConfigurationParameters.Milliseconds.of((long)3600000L);
    private static final ConfigurationParameters.Milliseconds ONE_DAY = ConfigurationParameters.Milliseconds.of((long)86400000L);

    public static DefaultSyncConfig of(ConfigurationParameters params) {
        DefaultSyncConfig cfg = new DefaultSyncConfigImpl().setName((String)params.getConfigValue(PARAM_NAME, (Object)PARAM_NAME_DEFAULT));
        cfg.user().setDisableMissing((Boolean)params.getConfigValue(PARAM_DISABLE_MISSING_USERS, (Object)false)).setMembershipExpirationTime(DefaultSyncConfigImpl.getMilliSeconds(params, PARAM_USER_MEMBERSHIP_EXPIRATION_TIME, "1h", ONE_HOUR)).setMembershipNestingDepth(((Integer)params.getConfigValue(PARAM_USER_MEMBERSHIP_NESTING_DEPTH, (Object)0)).intValue()).setDynamicMembership((Boolean)params.getConfigValue(PARAM_USER_DYNAMIC_MEMBERSHIP, (Object)false)).setExpirationTime(DefaultSyncConfigImpl.getMilliSeconds(params, PARAM_USER_EXPIRATION_TIME, "1h", ONE_HOUR)).setApplyRFC7613UsernameCaseMapped((Boolean)params.getConfigValue(PARAM_ENABLE_RFC7613_USERCASE_MAPPED_PROFILE, (Object)false)).setPathPrefix((String)params.getConfigValue(PARAM_USER_PATH_PREFIX, (Object)"")).setAutoMembership((String[])params.getConfigValue(PARAM_USER_AUTO_MEMBERSHIP, (Object)PARAM_USER_AUTO_MEMBERSHIP_DEFAULT)).setPropertyMapping(DefaultSyncConfigImpl.createMapping((String[])params.getConfigValue(PARAM_USER_PROPERTY_MAPPING, (Object)PARAM_USER_PROPERTY_MAPPING_DEFAULT)));
        cfg.group().setExpirationTime(DefaultSyncConfigImpl.getMilliSeconds(params, PARAM_GROUP_EXPIRATION_TIME, PARAM_GROUP_EXPIRATION_TIME_DEFAULT, ONE_DAY)).setApplyRFC7613UsernameCaseMapped((Boolean)params.getConfigValue(PARAM_ENABLE_RFC7613_USERCASE_MAPPED_PROFILE, (Object)false)).setPathPrefix((String)params.getConfigValue(PARAM_GROUP_PATH_PREFIX, (Object)"")).setAutoMembership((String[])params.getConfigValue(PARAM_GROUP_AUTO_MEMBERSHIP, (Object)PARAM_GROUP_AUTO_MEMBERSHIP_DEFAULT)).setPropertyMapping(DefaultSyncConfigImpl.createMapping((String[])params.getConfigValue(PARAM_GROUP_PROPERTY_MAPPING, (Object)PARAM_GROUP_PROPERTY_MAPPING_DEFAULT)));
        return cfg;
    }

    private static long getMilliSeconds(@Nonnull ConfigurationParameters params, @Nonnull String paramName, @Nonnull String defaultParamValue, @Nonnull ConfigurationParameters.Milliseconds defaultMillis) {
        return ConfigurationParameters.Milliseconds.of((String)((String)params.getConfigValue((String)paramName, (Object)defaultParamValue)), (ConfigurationParameters.Milliseconds)defaultMillis).value;
    }

    private static Map<String, String> createMapping(@Nonnull String[] patterns) {
        HashMap<String, String> mapping = new HashMap<String, String>();
        for (String pattern : patterns) {
            int idx = pattern.indexOf(61);
            if (idx <= 0) continue;
            String relPath = pattern.substring(0, idx).trim();
            String value = pattern.substring(idx + 1).trim();
            mapping.put(relPath, value);
        }
        return mapping;
    }
}

