/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.authorization.cug.impl;

import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.security.Principal;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.jcr.security.AccessControlException;
import org.apache.jackrabbit.api.security.principal.PrincipalManager;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.spi.security.authorization.cug.CugExclude;
import org.apache.jackrabbit.oak.spi.security.authorization.cug.CugPolicy;
import org.apache.jackrabbit.oak.spi.xml.ImportBehavior;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CugPolicyImpl
implements CugPolicy {
    private static final Logger log = LoggerFactory.getLogger(CugPolicyImpl.class);
    private final String oakPath;
    private final NamePathMapper namePathMapper;
    private final PrincipalManager principalManager;
    private final int importBehavior;
    private final CugExclude cugExclude;
    private final Set<Principal> principals = new HashSet<Principal>();

    CugPolicyImpl(@NotNull String oakPath, @NotNull NamePathMapper namePathMapper, @NotNull PrincipalManager principalManager, int importBehavior, @NotNull CugExclude cugExclude) {
        this(oakPath, namePathMapper, principalManager, importBehavior, cugExclude, Collections.emptySet());
    }

    CugPolicyImpl(@NotNull String oakPath, @NotNull NamePathMapper namePathMapper, @NotNull PrincipalManager principalManager, int importBehavior, @NotNull CugExclude cugExclude, @NotNull Set<Principal> principals) {
        ImportBehavior.nameFromValue((int)importBehavior);
        this.oakPath = oakPath;
        this.namePathMapper = namePathMapper;
        this.principalManager = principalManager;
        this.importBehavior = importBehavior;
        this.cugExclude = cugExclude;
        this.principals.addAll(principals);
    }

    @NotNull
    public Set<Principal> getPrincipals() {
        return Sets.newHashSet(this.principals);
    }

    public boolean addPrincipals(Principal ... principals) throws AccessControlException {
        boolean modified = false;
        for (Principal principal : principals) {
            if (!this.isValidPrincipal(principal)) continue;
            modified |= this.principals.add(principal);
        }
        return modified;
    }

    public boolean removePrincipals(Principal ... principals) {
        boolean modified = false;
        for (Principal principal : principals) {
            if (principal == null) continue;
            modified |= this.principals.remove(principal);
        }
        return modified;
    }

    public String getPath() {
        return this.namePathMapper.getJcrPath(this.oakPath);
    }

    Iterable<String> getPrincipalNames() {
        return Iterables.transform(this.principals, Principal::getName);
    }

    private boolean isValidPrincipal(@Nullable Principal principal) throws AccessControlException {
        if (principal == null) {
            log.debug("Ignoring null principal.");
            return false;
        }
        String name = principal.getName();
        if (Strings.isNullOrEmpty((String)name)) {
            throw new AccessControlException("Invalid principal " + name);
        }
        if (this.cugExclude.isExcluded(Collections.singleton(principal))) {
            log.warn("Attempt to add excluded principal {} to CUG.", (Object)principal);
            return false;
        }
        boolean isValid = true;
        switch (this.importBehavior) {
            case 3: {
                if (this.principalManager.hasPrincipal(name)) break;
                throw new AccessControlException("Unknown principal " + name);
            }
            case 1: {
                if (this.principalManager.hasPrincipal(name)) break;
                log.debug("Ignoring unknown principal {}", (Object)name);
                isValid = false;
                break;
            }
            case 2: {
                log.debug("Best effort: don't verify existence of principals.");
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported import behavior " + this.importBehavior);
            }
        }
        return isValid;
    }
}

