/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.authorization.cug.impl;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.security.Principal;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.jcr.security.AccessControlException;
import org.apache.jackrabbit.api.security.principal.PrincipalManager;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.spi.security.authorization.cug.CugPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CugPolicyImpl
implements CugPolicy {
    private static final Logger log = LoggerFactory.getLogger(CugPolicyImpl.class);
    private final String oakPath;
    private final NamePathMapper namePathMapper;
    private final PrincipalManager principalManager;
    private final int importBehavior;
    private final Set<Principal> principals = new HashSet<Principal>();

    CugPolicyImpl(@Nonnull String oakPath, @Nonnull NamePathMapper namePathMapper, @Nonnull PrincipalManager principalManager, int importBehavior) {
        this(oakPath, namePathMapper, principalManager, importBehavior, Collections.emptySet());
    }

    CugPolicyImpl(@Nonnull String oakPath, @Nonnull NamePathMapper namePathMapper, @Nonnull PrincipalManager principalManager, int importBehavior, @Nonnull Set<Principal> principals) {
        this.oakPath = oakPath;
        this.namePathMapper = namePathMapper;
        this.principalManager = principalManager;
        this.importBehavior = importBehavior;
        this.principals.addAll(principals);
    }

    @Override
    @Nonnull
    public Set<Principal> getPrincipals() {
        return Sets.newHashSet(this.principals);
    }

    @Override
    public boolean addPrincipals(Principal ... principals) throws AccessControlException {
        boolean modified = false;
        for (Principal principal : principals) {
            if (principal != null) {
                String name = principal.getName();
                if (name == null || name.isEmpty()) {
                    throw new AccessControlException("Invalid principal " + name);
                }
                Principal p = principal;
                switch (this.importBehavior) {
                    case 3: {
                        if (this.principalManager.hasPrincipal(name)) break;
                        throw new AccessControlException("Unknown principal " + name);
                    }
                    case 1: {
                        if (this.principalManager.hasPrincipal(name)) break;
                        log.debug("Ignoring unknown principal " + name);
                        p = null;
                        break;
                    }
                    case 2: {
                        log.debug("Best effort: don't verify existence of principals.");
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unsupported import behavior " + this.importBehavior);
                    }
                }
                if (p == null) continue;
                modified |= this.principals.add(p);
                continue;
            }
            log.debug("Ignoring null principal.");
        }
        return modified;
    }

    @Override
    public boolean removePrincipals(Principal ... principals) {
        boolean modified = false;
        for (Principal principal : principals) {
            if (principal == null) continue;
            modified |= this.principals.remove(principal);
        }
        return modified;
    }

    public String getPath() {
        return this.namePathMapper.getJcrPath(this.oakPath);
    }

    Iterable<String> getPrincipalNames() {
        return Iterables.transform(this.principals, (Function)new Function<Principal, String>(){

            public String apply(Principal principal) {
                return principal.getName();
            }
        });
    }
}

