/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.authorization.cug.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.TreeSet;
import javax.jcr.RepositoryException;
import javax.jcr.security.AccessControlException;
import javax.jcr.security.AccessControlPolicy;
import javax.jcr.security.AccessControlPolicyIterator;
import javax.jcr.security.Privilege;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlPolicy;
import org.apache.jackrabbit.api.security.principal.PrincipalManager;
import org.apache.jackrabbit.commons.iterator.AccessControlPolicyIteratorAdapter;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.plugins.tree.RootProvider;
import org.apache.jackrabbit.oak.plugins.tree.TreeUtil;
import org.apache.jackrabbit.oak.spi.security.ConfigurationParameters;
import org.apache.jackrabbit.oak.spi.security.SecurityProvider;
import org.apache.jackrabbit.oak.spi.security.authorization.AuthorizationConfiguration;
import org.apache.jackrabbit.oak.spi.security.authorization.accesscontrol.AbstractAccessControlManager;
import org.apache.jackrabbit.oak.spi.security.authorization.accesscontrol.PolicyOwner;
import org.apache.jackrabbit.oak.spi.security.authorization.cug.CugExclude;
import org.apache.jackrabbit.oak.spi.security.authorization.cug.CugPolicy;
import org.apache.jackrabbit.oak.spi.security.authorization.cug.impl.CugConstants;
import org.apache.jackrabbit.oak.spi.security.authorization.cug.impl.CugPolicyImpl;
import org.apache.jackrabbit.oak.spi.security.authorization.cug.impl.CugUtil;
import org.apache.jackrabbit.oak.spi.security.principal.PrincipalConfiguration;
import org.apache.jackrabbit.oak.spi.security.principal.PrincipalImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CugAccessControlManager
extends AbstractAccessControlManager
implements CugConstants,
PolicyOwner {
    private static final Logger log = LoggerFactory.getLogger(CugAccessControlManager.class);
    private final Set<String> supportedPaths;
    private final CugExclude cugExclude;
    private final ConfigurationParameters config;
    private final PrincipalManager principalManager;
    private final RootProvider rootProvider;

    CugAccessControlManager(@NotNull Root root, @NotNull NamePathMapper namePathMapper, @NotNull SecurityProvider securityProvider, @NotNull Set<String> supportedPaths, @NotNull CugExclude cugExclude, RootProvider rootProvider) {
        super(root, namePathMapper, securityProvider);
        this.supportedPaths = supportedPaths;
        this.cugExclude = cugExclude;
        this.config = ((AuthorizationConfiguration)securityProvider.getConfiguration(AuthorizationConfiguration.class)).getParameters();
        this.principalManager = ((PrincipalConfiguration)securityProvider.getConfiguration(PrincipalConfiguration.class)).getPrincipalManager(root, namePathMapper);
        this.rootProvider = rootProvider;
    }

    @NotNull
    public Privilege[] getSupportedPrivileges(@Nullable String absPath) throws RepositoryException {
        if (this.isSupportedPath(this.getOakPath(absPath))) {
            return new Privilege[]{this.privilegeFromName("jcr:read")};
        }
        return new Privilege[0];
    }

    public AccessControlPolicy[] getPolicies(String absPath) throws RepositoryException {
        CugPolicy cug;
        String oakPath = this.getOakPath(absPath);
        if (oakPath != null && this.isSupportedPath(oakPath) && (cug = this.getCugPolicy(oakPath)) != null) {
            return new AccessControlPolicy[]{cug};
        }
        return new AccessControlPolicy[0];
    }

    public AccessControlPolicy[] getEffectivePolicies(String absPath) throws RepositoryException {
        String oakPath = this.getOakPath(absPath);
        this.getTree(oakPath, 128L, true);
        boolean enabled = (Boolean)this.config.getConfigValue("cugEnabled", (Object)false);
        if (enabled) {
            Root r = this.getLatestRoot();
            ArrayList<CugPolicy> effective = new ArrayList<CugPolicy>();
            while (oakPath != null) {
                CugPolicy cug;
                if (CugUtil.isSupportedPath(oakPath, this.supportedPaths) && (cug = this.getCugPolicy(oakPath, r.getTree(oakPath), true)) != null) {
                    effective.add(cug);
                }
                oakPath = PathUtils.denotesRoot((String)oakPath) ? null : PathUtils.getAncestorPath((String)oakPath, (int)1);
            }
            return effective.toArray(new AccessControlPolicy[0]);
        }
        return new AccessControlPolicy[0];
    }

    public AccessControlPolicyIterator getApplicablePolicies(String absPath) throws RepositoryException {
        String oakPath = this.getOakPath(absPath);
        if (oakPath == null || !this.isSupportedPath(oakPath)) {
            return AccessControlPolicyIteratorAdapter.EMPTY;
        }
        CugPolicy cug = this.getCugPolicy(oakPath);
        if (cug == null) {
            cug = new CugPolicyImpl(oakPath, this.getNamePathMapper(), this.principalManager, CugUtil.getImportBehavior(this.config), this.cugExclude);
            return new AccessControlPolicyIteratorAdapter((Collection)ImmutableSet.of((Object)cug));
        }
        return AccessControlPolicyIteratorAdapter.EMPTY;
    }

    public void removePolicy(String absPath, AccessControlPolicy policy) throws RepositoryException {
        Tree cug;
        String oakPath = this.getOakPath(absPath);
        if (this.isSupportedPath(oakPath)) {
            CugAccessControlManager.checkValidPolicy(absPath, policy);
            Tree tree = this.getTree(oakPath, 256L, true);
            cug = tree.getChild("rep:cugPolicy");
            if (!CugUtil.definesCug(cug)) {
                throw new AccessControlException("Unexpected primary type of node rep:cugPolicy.");
            }
            HashSet mixins = Sets.newHashSet((Iterable)TreeUtil.getNames((Tree)tree, (String)"jcr:mixinTypes"));
            if (mixins.remove("rep:CugMixin")) {
                tree.setProperty("jcr:mixinTypes", (Object)mixins, Type.NAMES);
            } else {
                log.debug("Cannot remove mixin type {}", (Object)"rep:CugMixin");
            }
        } else {
            throw new AccessControlException("Unsupported path: " + absPath);
        }
        cug.remove();
    }

    public void setPolicy(String absPath, AccessControlPolicy policy) throws RepositoryException {
        Tree cug;
        String oakPath = this.getOakPath(absPath);
        if (this.isSupportedPath(oakPath)) {
            CugAccessControlManager.checkValidPolicy(absPath, policy);
            Tree tree = this.getTree(oakPath, 256L, true);
            Tree typeRoot = this.getRoot().getTree("/jcr:system/jcr:nodeTypes");
            if (!TreeUtil.isNodeType((Tree)tree, (String)"rep:CugMixin", (Tree)typeRoot)) {
                TreeUtil.addMixin((Tree)tree, (String)"rep:CugMixin", (Tree)typeRoot, null);
            }
            if (tree.hasChild("rep:cugPolicy")) {
                cug = tree.getChild("rep:cugPolicy");
                if (!CugUtil.definesCug(cug)) {
                    throw new AccessControlException("Unexpected primary type of node rep:cugPolicy.");
                }
            } else {
                cug = TreeUtil.addChild((Tree)tree, (String)"rep:cugPolicy", (String)"rep:CugPolicy", (Tree)typeRoot, null);
            }
        } else {
            throw new AccessControlException("Unsupported path: " + absPath);
        }
        cug.setProperty("rep:principalNames", ((CugPolicyImpl)policy).getPrincipalNames(), Type.STRINGS);
    }

    @NotNull
    public JackrabbitAccessControlPolicy[] getApplicablePolicies(@NotNull Principal principal) {
        return new JackrabbitAccessControlPolicy[0];
    }

    @NotNull
    public JackrabbitAccessControlPolicy[] getPolicies(@NotNull Principal principal) {
        return new JackrabbitAccessControlPolicy[0];
    }

    @NotNull
    public AccessControlPolicy[] getEffectivePolicies(@NotNull Set<Principal> principals) {
        if (!((Boolean)this.config.getConfigValue("cugEnabled", (Object)false)).booleanValue()) {
            return new AccessControlPolicy[0];
        }
        Root r = this.getLatestRoot();
        Set<String> candidates = this.collectEffectiveCandidates(r, Iterables.transform(principals, Principal::getName));
        if (candidates.isEmpty()) {
            return new AccessControlPolicy[0];
        }
        ArrayList<CugPolicy> effective = new ArrayList<CugPolicy>();
        for (String path : candidates) {
            CugPolicy cug;
            Tree t = r.getTree(path);
            if (!t.exists() || (cug = this.getCugPolicy(path, t, true)) == null) continue;
            effective.add(cug);
        }
        return effective.toArray(new AccessControlPolicy[0]);
    }

    public boolean defines(@Nullable String absPath, @NotNull AccessControlPolicy accessControlPolicy) {
        return CugAccessControlManager.isValidPolicy(absPath, accessControlPolicy);
    }

    private boolean isSupportedPath(@Nullable String oakPath) throws RepositoryException {
        this.checkValidPath(oakPath);
        return CugUtil.isSupportedPath(oakPath, this.supportedPaths);
    }

    private void checkValidPath(@Nullable String oakPath) throws RepositoryException {
        if (oakPath != null) {
            this.getTree(oakPath, 0L, false);
        }
    }

    @Nullable
    private CugPolicy getCugPolicy(@NotNull String oakPath) throws RepositoryException {
        return this.getCugPolicy(oakPath, this.getTree(oakPath, 128L, true), false);
    }

    @Nullable
    private CugPolicy getCugPolicy(@NotNull String oakPath, @NotNull Tree tree, boolean isEffective) {
        Tree cug = tree.getChild("rep:cugPolicy");
        if (CugUtil.definesCug(cug)) {
            return new CugPolicyImpl(oakPath, this.getNamePathMapper(), this.principalManager, CugUtil.getImportBehavior(this.config), this.cugExclude, this.getPrincipals(cug), isEffective);
        }
        return null;
    }

    private Iterable<Principal> getPrincipals(@NotNull Tree cugTree) {
        PropertyState property = cugTree.getProperty("rep:principalNames");
        if (property == null) {
            return Collections.emptySet();
        }
        return ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)((Iterable)property.getValue(Type.STRINGS)), principalName -> {
            Principal principal = this.principalManager.getPrincipal(principalName);
            if (principal == null) {
                log.debug("Unknown principal {}", principalName);
                principal = new PrincipalImpl(principalName);
            }
            return principal;
        }));
    }

    private static boolean isValidPolicy(@Nullable String absPath, @NotNull AccessControlPolicy policy) {
        return policy instanceof CugPolicyImpl && ((CugPolicyImpl)policy).getPath().equals(absPath);
    }

    private static void checkValidPolicy(@Nullable String absPath, @NotNull AccessControlPolicy policy) throws AccessControlException {
        if (!(policy instanceof CugPolicyImpl)) {
            throw new AccessControlException("Unsupported policy implementation: " + policy);
        }
        CugPolicyImpl cug = (CugPolicyImpl)policy;
        if (!cug.getPath().equals(absPath)) {
            throw new AccessControlException("Path mismatch: Expected " + cug.getPath() + ", Found: " + absPath);
        }
    }

    private Set<String> collectEffectiveCandidates(@NotNull Root r, @NotNull Iterable<String> principalNames) {
        Root immutableRoot = this.rootProvider.createReadOnlyRoot(r);
        TreeSet<String> candidates = new TreeSet<String>();
        LinkedList<String> eval = new LinkedList<String>();
        eval.add("/");
        while (!eval.isEmpty()) {
            Tree cug;
            String path = (String)eval.remove();
            Tree t = immutableRoot.getTree(path);
            if (PathUtils.denotesRoot((String)path)) {
                Iterables.addAll(eval, CugAccessControlManager.nestedCugPaths(t));
            }
            if (!CugUtil.isSupportedPath(path, this.supportedPaths) || (cug = CugUtil.getCug(t)) == null) continue;
            if (!Collections.disjoint(ImmutableSet.copyOf(principalNames), ImmutableSet.copyOf((Iterable)((Iterable)cug.getProperty("rep:principalNames").getValue(Type.STRINGS))))) {
                candidates.add(path);
            }
            Iterables.addAll(eval, CugAccessControlManager.nestedCugPaths(cug));
        }
        return candidates;
    }

    private static Iterable<String> nestedCugPaths(@NotNull Tree t) {
        PropertyState nested = t.getProperty(":nestedCugs");
        return nested != null ? (Iterable)nested.getValue(Type.STRINGS) : Collections.emptySet();
    }
}

