/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.authorization.cug.impl;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.plugins.memory.EmptyNodeState;
import org.apache.jackrabbit.oak.plugins.memory.PropertyBuilder;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.commit.PostValidationHook;
import org.apache.jackrabbit.oak.spi.security.authorization.cug.impl.CugConstants;
import org.apache.jackrabbit.oak.spi.security.authorization.cug.impl.CugUtil;
import org.apache.jackrabbit.oak.spi.state.DefaultNodeStateDiff;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStateDiff;
import org.apache.jackrabbit.oak.spi.state.NodeStateUtils;
import org.apache.jackrabbit.util.Text;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class NestedCugHook
implements PostValidationHook,
CugConstants {
    private static final Logger log = LoggerFactory.getLogger(NestedCugHook.class);
    private Set<String> deletedCUGs = Sets.newHashSet();
    private Set<String> moveSources = Sets.newHashSet();

    NestedCugHook() {
    }

    @NotNull
    public NodeState processCommit(NodeState before, NodeState after, CommitInfo info) {
        NodeBuilder builder = after.builder();
        after.compareAgainstBaseState(before, (NodeStateDiff)new Diff(before, builder));
        this.deletedCUGs.clear();
        this.moveSources.clear();
        return builder.getNodeState();
    }

    public String toString() {
        return "NestedCugHook";
    }

    private void addNestedCugPath(@NotNull NodeBuilder parentBuilder, @NotNull NodeBuilder builder, @NotNull String pathWithNewCug, boolean setCugCnt) {
        PropertyState ps = parentBuilder.getProperty(":nestedCugs");
        PropertyBuilder<String> pb = NestedCugHook.getHiddenPropertyBuilder(ps);
        if (ps != null) {
            ArrayList moveToNestedCug = Lists.newArrayList();
            for (String p : (Iterable)ps.getValue(Type.STRINGS)) {
                if (Text.isDescendant((String)pathWithNewCug, (String)p)) {
                    pb.removeValue((Object)p);
                    moveToNestedCug.add(p);
                } else if (p.equals(pathWithNewCug)) {
                    log.debug("Path of node holding a new nested CUG is already listed with the parent CUG.");
                    pb.removeValue((Object)p);
                }
                if (!this.isDeletedOrMoved(p)) continue;
                pb.removeValue((Object)p);
            }
            if (!moveToNestedCug.isEmpty()) {
                PropertyBuilder<String> pb2 = NestedCugHook.getHiddenPropertyBuilder(builder.getProperty(":nestedCugs"));
                pb2.addValues((Iterable)moveToNestedCug);
                builder.setProperty(pb2.getPropertyState());
            }
        }
        pb.addValue((Object)pathWithNewCug);
        parentBuilder.setProperty(pb.getPropertyState());
        if (setCugCnt) {
            parentBuilder.setProperty(":topCugCnt", (Object)pb.count(), Type.LONG);
        }
    }

    private boolean isDeletedOrMoved(@NotNull String path) {
        if (this.deletedCUGs.contains(path)) {
            return true;
        }
        for (String moveSource : this.moveSources) {
            if (!moveSource.equals(path) && !PathUtils.isAncestor((String)moveSource, (String)path)) continue;
            return true;
        }
        return false;
    }

    private static boolean removeNestedCugPath(@NotNull NodeBuilder parentBuilder, @NotNull String toRemove, @NotNull Iterable<String> toReconnect, boolean setCugCnt) {
        PropertyState ps = parentBuilder.getProperty(":nestedCugs");
        PropertyBuilder<String> pb = NestedCugHook.getHiddenPropertyBuilder(ps);
        if (pb.hasValue((Object)toRemove)) {
            pb.removeValue((Object)toRemove);
            pb.addValues(toReconnect);
            if (pb.isEmpty()) {
                parentBuilder.removeProperty(":nestedCugs");
                parentBuilder.removeProperty(":topCugCnt");
            } else {
                parentBuilder.setProperty(pb.getPropertyState());
                if (setCugCnt) {
                    parentBuilder.setProperty(":topCugCnt", (Object)pb.count(), Type.LONG);
                }
            }
            return true;
        }
        log.debug("Parent CUG doesn't contain expected entry for removed nested CUG");
        return false;
    }

    private static PropertyBuilder<String> getHiddenPropertyBuilder(@Nullable PropertyState ps) {
        return PropertyBuilder.copy((Type)Type.STRING, (PropertyState)ps).setName(":nestedCugs").setArray();
    }

    private final class Diff
    extends DefaultNodeStateDiff {
        private final Diff parentDiff;
        private final boolean isRoot;
        private String path;
        private NodeState beforeState = null;
        private NodeBuilder afterBuilder;
        private boolean afterHoldsCug;

        private Diff(@NotNull NodeState rootBefore, NodeBuilder rootAfter) {
            this.parentDiff = null;
            this.isRoot = true;
            this.path = "/";
            this.beforeState = rootBefore;
            this.afterBuilder = rootAfter;
            this.afterHoldsCug = CugUtil.hasCug(rootAfter);
        }

        private Diff(@NotNull Diff parentDiff, @Nullable String name, @Nullable NodeState before, NodeBuilder after) {
            this.parentDiff = parentDiff;
            this.isRoot = false;
            this.path = PathUtils.concat((String)parentDiff.path, (String)name);
            this.beforeState = before;
            this.afterBuilder = after;
            this.afterHoldsCug = CugUtil.hasCug(after);
        }

        public boolean childNodeAdded(String name, NodeState after) {
            if (!NodeStateUtils.isHidden((String)name)) {
                if (after.hasProperty(":source-path")) {
                    NestedCugHook.this.moveSources.add(after.getString(":source-path"));
                }
                if (CugUtil.definesCug(name, after)) {
                    if (this.isRoot) {
                        PropertyState alt = this.afterBuilder.getProperty(":nestedCugs");
                        if (alt != null) {
                            NodeBuilder cugNode = this.afterBuilder.getChildNode("rep:cugPolicy");
                            cugNode.setProperty(alt);
                            this.afterBuilder.removeProperty(":nestedCugs");
                            this.afterBuilder.removeProperty(":topCugCnt");
                        }
                    } else {
                        Diff diff = this.parentDiff;
                        while (diff != null) {
                            if (diff.afterHoldsCug) {
                                NodeBuilder cugNode = diff.afterBuilder.getChildNode("rep:cugPolicy");
                                NestedCugHook.this.addNestedCugPath(cugNode, this.afterBuilder.getChildNode("rep:cugPolicy"), this.path, false);
                                break;
                            }
                            if (diff.isRoot) {
                                NestedCugHook.this.addNestedCugPath(diff.afterBuilder, this.afterBuilder.getChildNode(name), this.path, true);
                            }
                            diff = diff.parentDiff;
                        }
                    }
                } else {
                    after.compareAgainstBaseState(EmptyNodeState.EMPTY_NODE, (NodeStateDiff)new Diff(this, name, null, this.afterBuilder.getChildNode(name)));
                }
            }
            return true;
        }

        public boolean childNodeChanged(String name, NodeState before, NodeState after) {
            if (!NodeStateUtils.isHidden((String)name)) {
                if (CugUtil.definesCug(name, after)) {
                    Diff diff = this.parentDiff;
                    while (diff != null) {
                        if (diff.afterHoldsCug) {
                            NodeBuilder cugNode = diff.afterBuilder.getChildNode("rep:cugPolicy");
                            NestedCugHook.this.addNestedCugPath(cugNode, this.afterBuilder.getChildNode("rep:cugPolicy"), this.path, false);
                        }
                        diff = diff.parentDiff;
                    }
                }
                after.compareAgainstBaseState(before, (NodeStateDiff)new Diff(this, name, before, this.afterBuilder.getChildNode(name)));
            }
            return true;
        }

        public boolean childNodeDeleted(String name, NodeState before) {
            if (!NodeStateUtils.isHidden((String)name)) {
                if (CugUtil.definesCug(name, before)) {
                    NestedCugHook.this.deletedCUGs.add(this.path);
                    Set<String> reconnect = this.getCugPathsToReconnect(before);
                    if (this.isRoot) {
                        if (!Iterables.isEmpty(reconnect)) {
                            this.afterBuilder.setProperty(":nestedCugs", reconnect, Type.STRINGS);
                            this.afterBuilder.setProperty(":topCugCnt", (Object)reconnect.size());
                        }
                    } else {
                        NodeBuilder cugNode;
                        Diff diff = this.parentDiff;
                        while (!(diff == null || diff.afterHoldsCug && NestedCugHook.removeNestedCugPath(cugNode = diff.afterBuilder.getChildNode("rep:cugPolicy"), this.path, reconnect, false))) {
                            PropertyState ps;
                            if (CugUtil.hasCug(diff.beforeState) && (ps = (cugNode = diff.beforeState.getChildNode("rep:cugPolicy")).getProperty(":nestedCugs")) != null && Iterables.contains((Iterable)((Iterable)ps.getValue(Type.STRINGS)), (Object)this.path)) {
                                log.debug("Nested cug property containing {} has also been removed; no reconnect required.", (Object)this.path);
                                break;
                            }
                            if (diff.isRoot && !NestedCugHook.removeNestedCugPath(diff.afterBuilder, this.path, reconnect, true)) {
                                log.warn("Failed to updated nested CUG info for path '{}'.", (Object)this.path);
                            }
                            diff = diff.parentDiff;
                        }
                    }
                } else {
                    EmptyNodeState.EMPTY_NODE.compareAgainstBaseState(before, (NodeStateDiff)new Diff(this, name, before, null));
                }
            }
            return true;
        }

        private Set<String> getCugPathsToReconnect(@NotNull NodeState before) {
            HashSet reconnect = Sets.newHashSet();
            if (this.afterBuilder != null) {
                for (String nestedCug : before.getStrings(":nestedCugs")) {
                    if (!PathUtils.isAncestor((String)this.path, (String)nestedCug)) {
                        log.debug("Nested CUG path '{}' is not a descendant of '{}'. Omitting from reconnect during CUG policy removal.", (Object)nestedCug, (Object)this.path);
                        continue;
                    }
                    if (NestedCugHook.this.deletedCUGs.contains(nestedCug)) {
                        log.debug("Ignoring removed CUG path '{}' from reconnection at {}.", (Object)nestedCug, (Object)this.path);
                        continue;
                    }
                    String relPath = PathUtils.relativize((String)this.path, (String)nestedCug);
                    NodeState ns = NodeStateUtils.getNode((NodeState)this.afterBuilder.getNodeState(), (String)relPath);
                    if (CugUtil.hasCug(ns)) {
                        reconnect.add(nestedCug);
                        log.debug("Marked nested CUG path '{}' for reconnection at {}.", (Object)nestedCug, (Object)this.path);
                        continue;
                    }
                    log.debug("Listed nested CUG path '{}' no longer holds a policy. Omitting from reconnect during CUG policy removal at {}.", (Object)nestedCug, (Object)this.path);
                }
            }
            return reconnect;
        }
    }
}

