/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.authorization.cug.impl;

import com.google.common.collect.ImmutableSet;
import java.security.Principal;
import java.util.Collections;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.plugins.tree.RootFactory;
import org.apache.jackrabbit.oak.plugins.tree.TreeContext;
import org.apache.jackrabbit.oak.plugins.tree.TreeFactory;
import org.apache.jackrabbit.oak.plugins.tree.TreeLocation;
import org.apache.jackrabbit.oak.plugins.tree.TreeType;
import org.apache.jackrabbit.oak.plugins.tree.TreeTypeProvider;
import org.apache.jackrabbit.oak.plugins.version.ReadOnlyVersionManager;
import org.apache.jackrabbit.oak.spi.security.Context;
import org.apache.jackrabbit.oak.spi.security.authorization.cug.impl.AbstractTreePermission;
import org.apache.jackrabbit.oak.spi.security.authorization.cug.impl.CugConstants;
import org.apache.jackrabbit.oak.spi.security.authorization.cug.impl.CugTreePermission;
import org.apache.jackrabbit.oak.spi.security.authorization.cug.impl.CugUtil;
import org.apache.jackrabbit.oak.spi.security.authorization.cug.impl.EmptyCugTreePermission;
import org.apache.jackrabbit.oak.spi.security.authorization.cug.impl.SupportedPaths;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.AggregatedPermissionProvider;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.Permissions;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.RepositoryPermission;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.TreePermission;
import org.apache.jackrabbit.oak.spi.security.privilege.PrivilegeBits;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStateUtils;
import org.apache.jackrabbit.oak.util.TreeUtil;

class CugPermissionProvider
implements AggregatedPermissionProvider,
CugConstants {
    private static final Set<String> READ_PRIVILEGE_NAMES = ImmutableSet.of((Object)"jcr:read", (Object)"rep:readNodes", (Object)"rep:readProperties");
    private final Root root;
    private final String workspaceName;
    private final String[] principalNames;
    private final TreeTypeProvider typeProvider;
    private final Context ctx;
    private final SupportedPaths supportedPaths;
    private Root immutableRoot;
    private ReadOnlyVersionManager versionManager;

    CugPermissionProvider(@Nonnull Root root, @Nonnull String workspaceName, @Nonnull Set<Principal> principals, @Nonnull Set<String> supportedPaths, @Nonnull Context ctx) {
        this.root = root;
        this.workspaceName = workspaceName;
        this.immutableRoot = RootFactory.createReadOnlyRoot((Root)root);
        this.principalNames = new String[principals.size()];
        int i = 0;
        for (Principal p : principals) {
            this.principalNames[i++] = p.getName();
        }
        this.supportedPaths = new SupportedPaths(supportedPaths);
        this.typeProvider = new TreeTypeProvider((TreeContext)ctx);
        this.ctx = ctx;
    }

    @Nonnull
    TreePermission getTreePermission(@Nonnull Tree parent, @Nonnull TreeType parentType, @Nonnull String childName, @Nonnull NodeState childState, @Nonnull AbstractTreePermission parentPermission) {
        Tree t = TreeFactory.createReadOnlyTree((Tree)parent, (String)childName, (NodeState)childState);
        TreeType type = this.typeProvider.getType(t, parentType);
        return this.getTreePermission(t, type, parentPermission);
    }

    boolean isAllow(@Nonnull Tree cugTree) {
        PropertyState princNamesState = cugTree.getProperty("rep:principalNames");
        if (princNamesState != null) {
            for (String pName : (Iterable)princNamesState.getValue(Type.STRINGS)) {
                for (String pN : this.principalNames) {
                    if (!pName.equals(pN)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public void refresh() {
        this.immutableRoot = RootFactory.createReadOnlyRoot((Root)this.root);
        this.versionManager = null;
    }

    @Nonnull
    public Set<String> getPrivileges(@Nullable Tree tree) {
        if (tree != null && this.canRead(tree)) {
            return READ_PRIVILEGE_NAMES;
        }
        return Collections.emptySet();
    }

    public boolean hasPrivileges(@Nullable Tree tree, String ... privilegeNames) {
        if (tree == null) {
            return false;
        }
        for (String privilegeName : privilegeNames) {
            if (READ_PRIVILEGE_NAMES.contains(privilegeName)) continue;
            return false;
        }
        return this.canRead(tree);
    }

    @Nonnull
    public RepositoryPermission getRepositoryPermission() {
        return RepositoryPermission.EMPTY;
    }

    @Nonnull
    public TreePermission getTreePermission(@Nonnull Tree tree, @Nonnull TreePermission parentPermission) {
        if (TreePermission.NO_RECOURSE == parentPermission) {
            throw new IllegalStateException("Attempt to create tree permission for unsupported path.");
        }
        Tree immutableTree = this.getImmutableTree(tree);
        TreeType type = this.typeProvider.getType(immutableTree);
        return this.getTreePermission(immutableTree, type, parentPermission);
    }

    public boolean isGranted(@Nonnull Tree tree, PropertyState property, long permissions) {
        if (CugPermissionProvider.isRead(permissions)) {
            return this.canRead(tree);
        }
        return false;
    }

    public boolean isGranted(@Nonnull String oakPath, @Nonnull String jcrActions) {
        TreeLocation location = TreeLocation.create((Root)this.immutableRoot, (String)oakPath);
        if (this.ctx.definesLocation(location) || NodeStateUtils.isHiddenPath((String)oakPath)) {
            return false;
        }
        long permissions = Permissions.getPermissions((String)jcrActions, (TreeLocation)location, (boolean)false);
        return this.isGranted(location, permissions);
    }

    @Nonnull
    public PrivilegeBits supportedPrivileges(@Nullable Tree tree, @Nullable PrivilegeBits privilegeBits) {
        PrivilegeBits pb;
        if (tree == null) {
            return PrivilegeBits.EMPTY;
        }
        if (privilegeBits == null) {
            pb = (PrivilegeBits)PrivilegeBits.BUILT_IN.get("jcr:read");
        } else {
            pb = PrivilegeBits.getInstance((PrivilegeBits[])new PrivilegeBits[]{privilegeBits});
            pb.retain((PrivilegeBits)PrivilegeBits.BUILT_IN.get("jcr:read"));
        }
        if (pb.isEmpty() || !this.includesCug(tree)) {
            return PrivilegeBits.EMPTY;
        }
        return pb;
    }

    public long supportedPermissions(@Nullable Tree tree, @Nullable PropertyState property, long permissions) {
        if (tree == null) {
            return 0L;
        }
        long supported = permissions & 3L;
        if (supported != 0L && this.includesCug(tree)) {
            return supported;
        }
        return 0L;
    }

    public long supportedPermissions(@Nonnull TreeLocation location, long permissions) {
        long supported = permissions & 3L;
        if (supported != 0L && this.includesCug(CugPermissionProvider.getTreeFromLocation(location))) {
            return supported;
        }
        return 0L;
    }

    public long supportedPermissions(@Nonnull TreePermission treePermission, @Nullable PropertyState propertyState, long permissions) {
        long supported = permissions & 3L;
        if (supported != 0L && treePermission instanceof CugTreePermission && ((CugTreePermission)treePermission).isInCug()) {
            return supported;
        }
        return 0L;
    }

    public boolean isGranted(@Nonnull TreeLocation location, long permissions) {
        Tree tree;
        if (CugPermissionProvider.isRead(permissions) && (tree = CugPermissionProvider.getTreeFromLocation(location)) != null) {
            return this.isGranted(tree, location.getProperty(), permissions);
        }
        return false;
    }

    @Nonnull
    public TreePermission getTreePermission(@Nonnull Tree immutableTree, @Nonnull TreeType type, @Nonnull TreePermission parentPermission) {
        String path;
        if (!CugPermissionProvider.isSupportedType(type)) {
            return TreePermission.NO_RECOURSE;
        }
        boolean parentIsCugPermission = parentPermission instanceof CugTreePermission;
        Object tp = TreeType.VERSION == type ? this.createVersionPermission(immutableTree, type, parentPermission, parentIsCugPermission) : (parentIsCugPermission ? new CugTreePermission(immutableTree, type, parentPermission, this) : (this.supportedPaths.includes(path = immutableTree.getPath()) ? new CugTreePermission(immutableTree, type, parentPermission, this) : (this.supportedPaths.mayContainCug(path) || CugPermissionProvider.isJcrSystemPath(immutableTree) ? new EmptyCugTreePermission(immutableTree, type, this) : TreePermission.NO_RECOURSE)));
        return tp;
    }

    private static boolean isJcrSystemPath(@Nonnull Tree tree) {
        return "jcr:system".equals(tree.getName());
    }

    private static boolean isRead(long permission) {
        return permission == 1L || permission == 2L || permission == 3L;
    }

    private static boolean isSupportedType(@Nonnull TreeType type) {
        return type == TreeType.DEFAULT || type == TreeType.VERSION;
    }

    private boolean includesCug(@CheckForNull Tree tree) {
        Tree immutableTree;
        TreeType type;
        if (tree != null && CugPermissionProvider.isSupportedType(type = this.typeProvider.getType(immutableTree = this.getImmutableTree(tree)))) {
            return this.getCugRoot(immutableTree, type) != null;
        }
        return false;
    }

    @CheckForNull
    private Tree getCugRoot(@Nonnull Tree immutableTree, @Nonnull TreeType type) {
        String parentPath;
        Tree tree = immutableTree;
        String p = immutableTree.getPath();
        if (TreeType.VERSION == type && !ReadOnlyVersionManager.isVersionStoreTree((Tree)tree)) {
            tree = this.getVersionManager().getVersionable(immutableTree, this.workspaceName);
            if (tree == null) {
                return null;
            }
            p = tree.getPath();
        }
        if (!this.supportedPaths.includes(p)) {
            return null;
        }
        if (CugUtil.hasCug(tree)) {
            return tree;
        }
        while (!tree.isRoot() && this.supportedPaths.includes(parentPath = PathUtils.getParentPath((String)p))) {
            if (!CugUtil.hasCug(tree = tree.getParent())) continue;
            return tree;
        }
        return null;
    }

    private boolean canRead(@Nonnull Tree tree) {
        Tree cugTree;
        Tree immutableTree = this.getImmutableTree(tree);
        TreeType type = this.typeProvider.getType(immutableTree);
        if (!CugPermissionProvider.isSupportedType(type)) {
            return false;
        }
        Tree cugRoot = this.getCugRoot(immutableTree, type);
        if (cugRoot != null && (cugTree = CugUtil.getCug(cugRoot)) != null) {
            return this.isAllow(cugTree);
        }
        return false;
    }

    @Nonnull
    private Tree getImmutableTree(@Nonnull Tree tree) {
        return TreeUtil.isReadOnlyTree((Tree)tree) ? tree : this.immutableRoot.getTree(tree.getPath());
    }

    @CheckForNull
    private static Tree getTreeFromLocation(@Nonnull TreeLocation location) {
        Tree tree;
        Tree tree2 = tree = location.getProperty() == null ? location.getTree() : location.getParent().getTree();
        while (tree == null && !PathUtils.denotesRoot((String)location.getPath())) {
            location = location.getParent();
            tree = location.getTree();
        }
        return tree;
    }

    @Nonnull
    private TreePermission createVersionPermission(@Nonnull Tree tree, @Nonnull TreeType type, @Nonnull TreePermission parent, boolean parentIsCugPermission) {
        TreePermission tp;
        if (ReadOnlyVersionManager.isVersionStoreTree((Tree)tree)) {
            if (parentIsCugPermission) {
                return new CugTreePermission(tree, type, parent, this);
            }
            return new EmptyCugTreePermission(tree, type, this);
        }
        Tree versionableTree = this.getVersionManager().getVersionable(tree, this.workspaceName);
        if (versionableTree == null) {
            return TreePermission.NO_RECOURSE;
        }
        TreeType versionableType = this.typeProvider.getType(versionableTree);
        if (!CugPermissionProvider.isSupportedType(versionableType)) {
            return TreePermission.NO_RECOURSE;
        }
        String path = versionableTree.getPath();
        boolean isSupportedPath = false;
        Tree cug = null;
        if (parentIsCugPermission) {
            cug = CugUtil.getCug(versionableTree);
        } else if (this.supportedPaths.includes(path)) {
            isSupportedPath = true;
            Tree cugRoot = this.getCugRoot(versionableTree, versionableType);
            if (cugRoot != null) {
                cug = CugUtil.getCug(cugRoot);
            }
        }
        if (cug != null) {
            tp = new CugTreePermission(tree, type, parent, this, true, this.isAllow(cug));
        } else if (parentIsCugPermission) {
            CugTreePermission ctp = (CugTreePermission)parent;
            tp = new CugTreePermission(tree, type, parent, this, ctp.isInCug(), ctp.isAllow());
        } else {
            tp = isSupportedPath ? new CugTreePermission(tree, type, parent, this, false, false) : (this.supportedPaths.mayContainCug(path) ? new EmptyCugTreePermission(tree, type, this) : TreePermission.NO_RECOURSE);
        }
        return tp;
    }

    @Nonnull
    private ReadOnlyVersionManager getVersionManager() {
        if (this.versionManager == null) {
            this.versionManager = ReadOnlyVersionManager.getInstance((Root)this.immutableRoot, (NamePathMapper)NamePathMapper.DEFAULT);
        }
        return this.versionManager;
    }
}

