/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.authorization.cug.impl;

import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.plugins.tree.TreeType;
import org.apache.jackrabbit.oak.spi.security.authorization.cug.impl.AbstractTreePermission;
import org.apache.jackrabbit.oak.spi.security.authorization.cug.impl.CugConstants;
import org.apache.jackrabbit.oak.spi.security.authorization.cug.impl.CugPermissionProvider;
import org.apache.jackrabbit.oak.spi.security.authorization.cug.impl.CugUtil;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.TreePermission;

final class CugTreePermission
extends AbstractTreePermission
implements CugConstants {
    private final TreePermission parent;
    private Boolean inCug;
    private Boolean allow;

    CugTreePermission(@Nonnull Tree tree, @Nonnull TreeType type, @Nonnull TreePermission parent, @Nonnull CugPermissionProvider permissionProvider) {
        super(tree, type, permissionProvider);
        this.parent = parent;
    }

    CugTreePermission(@Nonnull Tree tree, @Nonnull TreeType type, @Nonnull TreePermission parent, @Nonnull CugPermissionProvider permissionProvider, boolean inCug, boolean canRead) {
        super(tree, type, permissionProvider);
        this.parent = parent;
        this.inCug = inCug;
        this.allow = canRead;
    }

    boolean isInCug() {
        if (this.inCug == null) {
            this.loadCug();
        }
        return this.inCug;
    }

    boolean isAllow() {
        if (this.allow == null) {
            this.loadCug();
        }
        return this.allow;
    }

    private void loadCug() {
        Tree cugTree = CugUtil.getCug(this.tree);
        if (cugTree != null) {
            this.inCug = true;
            this.allow = this.permissionProvider.isAllow(cugTree);
        } else if (this.parent instanceof CugTreePermission) {
            this.inCug = ((CugTreePermission)this.parent).isInCug();
            this.allow = ((CugTreePermission)this.parent).isAllow();
        } else {
            this.inCug = false;
            this.allow = false;
        }
    }

    public boolean canRead() {
        return this.isAllow();
    }

    public boolean canRead(@Nonnull PropertyState property) {
        return this.isAllow();
    }

    public boolean canReadAll() {
        return false;
    }

    public boolean canReadProperties() {
        return this.isAllow();
    }

    public boolean isGranted(long permissions) {
        return permissions == 1L && this.isAllow();
    }

    public boolean isGranted(long permissions, @Nonnull PropertyState property) {
        return permissions == 2L && this.isAllow();
    }
}

