/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.authorization.cug.impl;

import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.plugins.nodetype.ReadOnlyNodeTypeManager;
import org.apache.jackrabbit.oak.plugins.nodetype.write.NodeTypeRegistry;
import org.apache.jackrabbit.oak.spi.security.ConfigurationParameters;
import org.apache.jackrabbit.oak.spi.security.authorization.cug.impl.CugConfiguration;
import org.apache.jackrabbit.oak.spi.security.authorization.cug.impl.CugConstants;
import org.apache.jackrabbit.oak.spi.xml.ImportBehavior;
import org.apache.jackrabbit.oak.util.TreeUtil;
import org.apache.jackrabbit.util.Text;

final class CugUtil
implements CugConstants {
    private CugUtil() {
    }

    public static boolean definesCug(@Nonnull Tree tree) {
        return tree.exists() && "rep:cugPolicy".equals(tree.getName()) && "rep:CugPolicy".equals(TreeUtil.getPrimaryTypeName((Tree)tree));
    }

    public static boolean definesCug(@Nonnull Tree tree, @Nonnull PropertyState property) {
        return "rep:principalNames".equals(property.getName()) && CugUtil.definesCug(tree);
    }

    public static boolean isSupportedPath(@Nullable String oakPath, @Nonnull ConfigurationParameters config) {
        if (oakPath == null) {
            return false;
        }
        for (String supportedPath : (String[])config.getConfigValue("cugSupportedPaths", (Object)new String[0])) {
            if (!Text.isDescendantOrEqual((String)supportedPath, (String)oakPath)) continue;
            return true;
        }
        return false;
    }

    public static int getImportBehavior(ConfigurationParameters config) {
        String importBehaviorStr = (String)config.getConfigValue("importBehavior", (Object)"abort");
        return ImportBehavior.valueFromString((String)importBehaviorStr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean registerCugNodeTypes(final @Nonnull Root root) {
        block6: {
            boolean bl;
            ReadOnlyNodeTypeManager ntMgr = new ReadOnlyNodeTypeManager(){

                protected Tree getTypes() {
                    return root.getTree("/jcr:system/jcr:nodeTypes");
                }
            };
            if (ntMgr.hasNodeType("rep:CugPolicy")) break block6;
            InputStream stream = CugConfiguration.class.getResourceAsStream("cug_nodetypes.cnd");
            try {
                NodeTypeRegistry.register((Root)root, (InputStream)stream, (String)"cug node types");
                bl = true;
            }
            catch (Throwable throwable) {
                try {
                    stream.close();
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalStateException("Unable to read cug node types", e);
                }
                catch (RepositoryException e) {
                    throw new IllegalStateException("Unable to read cug node types", e);
                }
            }
            stream.close();
            return bl;
        }
        return false;
    }
}

