/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.authorization.cug.impl;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.security.Principal;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.plugins.tree.RootFactory;
import org.apache.jackrabbit.oak.plugins.tree.TreeLocation;
import org.apache.jackrabbit.oak.spi.security.Context;
import org.apache.jackrabbit.oak.spi.security.authorization.cug.impl.CugConstants;
import org.apache.jackrabbit.oak.spi.security.authorization.cug.impl.CugTreePermission;
import org.apache.jackrabbit.oak.spi.security.authorization.cug.impl.CugUtil;
import org.apache.jackrabbit.oak.spi.security.authorization.cug.impl.EmptyCugTreePermission;
import org.apache.jackrabbit.oak.spi.security.authorization.cug.impl.SupportedPaths;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.AggregatedPermissionProvider;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.PermissionProvider;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.Permissions;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.RepositoryPermission;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.TreePermission;
import org.apache.jackrabbit.oak.spi.security.privilege.PrivilegeBits;
import org.apache.jackrabbit.oak.util.TreeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CugPermissionProvider
implements AggregatedPermissionProvider,
CugConstants {
    private static final Logger log = LoggerFactory.getLogger(CugPermissionProvider.class);
    private static final Set<String> READ_PRIVILEGE_NAMES = ImmutableSet.of((Object)"jcr:read", (Object)"rep:readNodes", (Object)"rep:readProperties");
    private final Root root;
    private final Set<String> principalNames;
    private final Context ctx;
    private final SupportedPaths supportedPaths;
    private Root immutableRoot;

    CugPermissionProvider(@Nonnull Root root, @Nonnull Set<Principal> principals, @Nonnull Set<String> supportedPaths, @Nonnull Context ctx) {
        this.root = root;
        this.immutableRoot = RootFactory.createReadOnlyRoot((Root)root);
        this.principalNames = new HashSet<String>(principals.size());
        for (Principal p : Iterables.filter(principals, (Predicate)Predicates.notNull())) {
            this.principalNames.add(p.getName());
        }
        this.supportedPaths = new SupportedPaths(supportedPaths);
        this.ctx = ctx;
    }

    public void refresh() {
        this.immutableRoot = RootFactory.createReadOnlyRoot((Root)this.root);
    }

    @Nonnull
    public Set<String> getPrivileges(@Nullable Tree tree) {
        if (tree != null && this.canRead(tree)) {
            return READ_PRIVILEGE_NAMES;
        }
        return Collections.emptySet();
    }

    public boolean hasPrivileges(@Nullable Tree tree, String ... privilegeNames) {
        if (tree == null) {
            return false;
        }
        for (String privilegeName : privilegeNames) {
            if (READ_PRIVILEGE_NAMES.contains(privilegeName)) continue;
            return false;
        }
        return this.canRead(tree);
    }

    @Nonnull
    public RepositoryPermission getRepositoryPermission() {
        return RepositoryPermission.EMPTY;
    }

    @Nonnull
    public TreePermission getTreePermission(@Nonnull Tree tree, @Nonnull TreePermission parentPermission) {
        Object tp;
        Tree immutableTree = this.getImmutableTree(tree);
        if (parentPermission == TreePermission.EMPTY && !immutableTree.isRoot() || this.isAcContent(immutableTree, true)) {
            return TreePermission.EMPTY;
        }
        if (parentPermission instanceof CugTreePermission) {
            tp = new CugTreePermission(immutableTree, (CugTreePermission)parentPermission);
            if (CugPermissionProvider.hasCug(immutableTree)) {
                tp = this.createCugPermission(immutableTree, (TreePermission)tp);
            }
        } else {
            String path = immutableTree.getPath();
            tp = this.supportedPaths.includes(path) ? this.createCugPermission(immutableTree, null) : (this.supportedPaths.mayContainCug(path) ? new EmptyCugTreePermission(immutableTree, (PermissionProvider)this) : TreePermission.EMPTY);
        }
        return tp;
    }

    public boolean isGranted(@Nonnull Tree tree, PropertyState property, long permissions) {
        if (CugPermissionProvider.isRead(permissions)) {
            return this.canRead(tree);
        }
        return false;
    }

    public boolean isGranted(@Nonnull String oakPath, @Nonnull String jcrActions) {
        TreeLocation location = TreeLocation.create((Root)this.immutableRoot, (String)oakPath);
        boolean isAcContent = this.isAcContent(location);
        long permissions = Permissions.getPermissions((String)jcrActions, (TreeLocation)location, (boolean)isAcContent);
        return this.isGranted(location, permissions);
    }

    public PrivilegeBits supportedPrivileges(@Nullable Tree tree, @Nullable PrivilegeBits privilegeBits) {
        PrivilegeBits pb;
        if (tree == null) {
            return PrivilegeBits.EMPTY;
        }
        if (privilegeBits == null) {
            pb = (PrivilegeBits)PrivilegeBits.BUILT_IN.get("jcr:read");
        } else {
            pb = PrivilegeBits.getInstance((PrivilegeBits[])new PrivilegeBits[]{privilegeBits});
            pb.retain((PrivilegeBits)PrivilegeBits.BUILT_IN.get("jcr:read"));
        }
        if (pb.isEmpty() || !this.includesCug(tree, tree.getPath())) {
            return PrivilegeBits.EMPTY;
        }
        return pb;
    }

    public long supportedPermissions(@Nullable Tree tree, @Nullable PropertyState property, long permissions) {
        if (tree == null) {
            return 0L;
        }
        long supported = permissions & 3L;
        if (supported != 0L && this.includesCug(tree, tree.getPath())) {
            return supported;
        }
        return 0L;
    }

    public long supportedPermissions(@Nonnull TreeLocation location, long permissions) {
        long supported = permissions & 3L;
        if (supported != 0L && this.includesCug(CugPermissionProvider.getTreeFromLocation(location, location.getProperty()), location.getPath())) {
            return supported;
        }
        return 0L;
    }

    public long supportedPermissions(@Nonnull TreePermission treePermission, long permissions) {
        long supported = permissions & 3L;
        if (supported != 0L && treePermission instanceof CugTreePermission) {
            return supported;
        }
        return 0L;
    }

    public boolean isGranted(@Nonnull TreeLocation location, long permissions) {
        PropertyState property;
        Tree tree;
        if (CugPermissionProvider.isRead(permissions) && (tree = CugPermissionProvider.getTreeFromLocation(location, property = location.getProperty())) != null) {
            return this.isGranted(tree, property, permissions);
        }
        return false;
    }

    private static boolean isRead(long permission) {
        return permission == 1L || permission == 2L || permission == 3L;
    }

    private static boolean hasCug(@Nonnull Tree tree) {
        return tree.exists() && tree.hasChild("rep:cugPolicy");
    }

    private boolean isAcContent(@Nonnull Tree tree, boolean testForCtxRoot) {
        return testForCtxRoot ? this.ctx.definesContextRoot(tree) : this.ctx.definesTree(tree);
    }

    private boolean isAcContent(@Nonnull TreeLocation location) {
        return this.ctx.definesLocation(location);
    }

    private boolean includesCug(@CheckForNull Tree tree, @Nonnull String path) {
        return tree != null && this.getCugRoot(tree, path) != null;
    }

    @CheckForNull
    private Tree getCugRoot(@Nonnull Tree tree, @Nonnull String path) {
        String parentPath;
        if (!this.supportedPaths.includes(path)) {
            return null;
        }
        Tree immutableTree = this.getImmutableTree(tree);
        if (CugPermissionProvider.hasCug(immutableTree)) {
            return immutableTree;
        }
        while (!immutableTree.isRoot() && this.supportedPaths.includes(parentPath = PathUtils.getParentPath((String)path))) {
            if (!CugPermissionProvider.hasCug(immutableTree = immutableTree.getParent())) continue;
            return immutableTree;
        }
        return null;
    }

    private boolean canRead(@Nonnull Tree tree) {
        Tree immutableTree = this.getImmutableTree(tree);
        if (this.isAcContent(immutableTree, false)) {
            return false;
        }
        Tree cugRoot = this.getCugRoot(immutableTree, immutableTree.getPath());
        return cugRoot != null && this.createCugPermission(cugRoot, null).canRead();
    }

    @Nonnull
    private Tree getImmutableTree(@Nonnull Tree tree) {
        return TreeUtil.isReadOnlyTree((Tree)tree) ? tree : this.immutableRoot.getTree(tree.getPath());
    }

    @CheckForNull
    private static Tree getTreeFromLocation(@Nonnull TreeLocation location, @CheckForNull PropertyState property) {
        Tree tree;
        Tree tree2 = tree = property == null ? location.getTree() : location.getParent().getTree();
        while (tree == null && !PathUtils.denotesRoot((String)location.getPath())) {
            location = location.getParent();
            tree = location.getTree();
        }
        return tree;
    }

    @Nonnull
    private TreePermission createCugPermission(@Nonnull Tree tree, @Nullable TreePermission fallback) {
        Tree cugTree = tree.getChild("rep:cugPolicy");
        if (CugUtil.definesCug(cugTree)) {
            PropertyState princNamesState = cugTree.getProperty("rep:principalNames");
            if (princNamesState != null) {
                boolean allow = false;
                for (String pName : (Iterable)princNamesState.getValue(Type.STRINGS)) {
                    if (!this.principalNames.contains(pName)) continue;
                    allow = true;
                    break;
                }
                return new CugTreePermission(tree, allow, (PermissionProvider)this);
            }
            log.warn("Tree at {0} doesn't represent a valid CUG.", (Object)cugTree.getPath());
        }
        return fallback == null ? new EmptyCugTreePermission(tree, (PermissionProvider)this) : fallback;
    }
}

