/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.authorization.cug.impl;

import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.PermissionProvider;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.TreePermission;
import org.apache.jackrabbit.oak.spi.state.NodeState;

final class CugTreePermission
implements TreePermission {
    private final Tree tree;
    private final boolean allow;
    private final PermissionProvider permissionProvider;

    CugTreePermission(@Nonnull Tree tree, boolean allow, @Nonnull PermissionProvider permissionProvider) {
        this.tree = tree;
        this.allow = allow;
        this.permissionProvider = permissionProvider;
    }

    CugTreePermission(@Nonnull Tree tree, @Nonnull CugTreePermission parent) {
        this.tree = tree;
        this.allow = parent.allow;
        this.permissionProvider = parent.permissionProvider;
    }

    @Nonnull
    public TreePermission getChildPermission(@Nonnull String childName, @Nonnull NodeState childState) {
        return this.permissionProvider.getTreePermission(this.tree.getChild(childName), (TreePermission)this);
    }

    public boolean canRead() {
        return this.allow;
    }

    public boolean canRead(@Nonnull PropertyState property) {
        return this.allow;
    }

    public boolean canReadAll() {
        return false;
    }

    public boolean canReadProperties() {
        return false;
    }

    public boolean isGranted(long permissions) {
        return this.allow && permissions == 1L;
    }

    public boolean isGranted(long permissions, @Nonnull PropertyState property) {
        return this.allow && permissions == 2L;
    }
}

