/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.authorization.cug.impl;

import java.security.AccessControlException;
import java.security.Principal;
import java.util.HashSet;
import java.util.Set;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.nodetype.PropertyDefinition;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.apache.jackrabbit.api.security.principal.PrincipalManager;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.spi.mount.MountInfoProvider;
import org.apache.jackrabbit.oak.spi.security.ConfigurationParameters;
import org.apache.jackrabbit.oak.spi.security.SecurityProvider;
import org.apache.jackrabbit.oak.spi.security.authorization.AuthorizationConfiguration;
import org.apache.jackrabbit.oak.spi.security.authorization.cug.impl.CugConstants;
import org.apache.jackrabbit.oak.spi.security.authorization.cug.impl.CugUtil;
import org.apache.jackrabbit.oak.spi.security.principal.PrincipalConfiguration;
import org.apache.jackrabbit.oak.spi.xml.PropInfo;
import org.apache.jackrabbit.oak.spi.xml.ProtectedPropertyImporter;
import org.apache.jackrabbit.oak.spi.xml.ReferenceChangeTracker;
import org.apache.jackrabbit.oak.spi.xml.TextValue;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CugImporter
implements ProtectedPropertyImporter,
CugConstants {
    private static final Logger log = LoggerFactory.getLogger(CugImporter.class);
    private final MountInfoProvider mountInfoProvider;
    private boolean initialized;
    private Set<String> supportedPaths;
    private int importBehavior;
    private PrincipalManager principalManager;

    CugImporter(@NotNull MountInfoProvider mountInfoProvider) {
        this.mountInfoProvider = mountInfoProvider;
    }

    public boolean init(@NotNull Session session, @NotNull Root root, @NotNull NamePathMapper namePathMapper, boolean isWorkspaceImport, int uuidBehavior, @NotNull ReferenceChangeTracker referenceTracker, @NotNull SecurityProvider securityProvider) {
        if (this.initialized) {
            throw new IllegalStateException("Already initialized");
        }
        try {
            ConfigurationParameters config = ((AuthorizationConfiguration)securityProvider.getConfiguration(AuthorizationConfiguration.class)).getParameters();
            this.supportedPaths = CugUtil.getSupportedPaths(config, this.mountInfoProvider);
            this.importBehavior = CugUtil.getImportBehavior(config);
            if (isWorkspaceImport) {
                PrincipalConfiguration pConfig = (PrincipalConfiguration)securityProvider.getConfiguration(PrincipalConfiguration.class);
                this.principalManager = pConfig.getPrincipalManager(root, namePathMapper);
            } else {
                this.principalManager = ((JackrabbitSession)session).getPrincipalManager();
            }
            this.initialized = true;
        }
        catch (RepositoryException e) {
            log.warn("Error while initializing cug importer", (Throwable)e);
        }
        return this.initialized;
    }

    public void processReferences() {
    }

    public boolean handlePropInfo(@NotNull Tree parent, @NotNull PropInfo protectedPropInfo, @NotNull PropertyDefinition def) {
        if (CugUtil.definesCug(parent) && this.isValid(protectedPropInfo, def) && CugUtil.isSupportedPath(parent.getPath(), this.supportedPaths)) {
            HashSet<String> principalNames = new HashSet<String>();
            block4: for (TextValue txtValue : protectedPropInfo.getTextValues()) {
                String principalName = txtValue.getString();
                Principal principal = this.principalManager.getPrincipal(principalName);
                if (principal == null) {
                    switch (this.importBehavior) {
                        case 1: {
                            log.debug("Ignoring unknown principal with name '{}'.", (Object)principalName);
                            continue block4;
                        }
                        case 2: {
                            log.debug("Importing unknown principal '{}'", (Object)principalName);
                            principalNames.add(principalName);
                            continue block4;
                        }
                    }
                    throw new AccessControlException("Unknown principal '" + principalName + "'.");
                }
                principalNames.add(principalName);
            }
            parent.setProperty("rep:principalNames", principalNames, Type.STRINGS);
            return true;
        }
        return false;
    }

    public void propertiesCompleted(@NotNull Tree protectedParent) throws IllegalStateException {
        if (CugUtil.definesCug(protectedParent) && !protectedParent.hasProperty("rep:principalNames")) {
            log.debug("Removing incomplete rep:cugPolicy node (due to missing mandatory property or unsupported path).");
            protectedParent.remove();
        }
    }

    private boolean isValid(@NotNull PropInfo propInfo, @NotNull PropertyDefinition def) {
        if ("rep:principalNames".equals(propInfo.getName())) {
            return def.isMultiple() && "rep:CugPolicy".equals(def.getDeclaringNodeType().getName());
        }
        return false;
    }
}

