/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.authorization.cug.impl;

import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.plugins.tree.TreeLocation;
import org.apache.jackrabbit.oak.spi.security.Context;
import org.apache.jackrabbit.oak.spi.security.authorization.cug.impl.CugConstants;
import org.apache.jackrabbit.oak.spi.security.authorization.cug.impl.CugUtil;
import org.apache.jackrabbit.util.Text;
import org.jetbrains.annotations.NotNull;

final class CugContext
implements Context,
CugConstants {
    static final Context INSTANCE = new CugContext();

    private CugContext() {
    }

    public boolean definesProperty(@NotNull Tree parent, @NotNull PropertyState property) {
        return CugUtil.definesCug(parent, property);
    }

    public boolean definesContextRoot(@NotNull Tree tree) {
        return CugUtil.definesCug(tree);
    }

    public boolean definesTree(@NotNull Tree tree) {
        return CugUtil.definesCug(tree);
    }

    public boolean definesLocation(@NotNull TreeLocation location) {
        Tree tree;
        PropertyState p = location.getProperty();
        Tree tree2 = tree = p == null ? location.getTree() : location.getParent().getTree();
        if (tree != null) {
            return p == null ? this.definesTree(tree) : this.definesProperty(tree, p);
        }
        String path = location.getPath();
        return "rep:cugPolicy".equals(Text.getName((String)path)) || path.endsWith("rep:cugPolicy/rep:principalNames");
    }

    public boolean definesInternal(@NotNull Tree tree) {
        return false;
    }
}

