/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.authorization.cug.impl;

import com.google.common.collect.ImmutableSet;
import java.security.Principal;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.jackrabbit.oak.commons.PropertiesUtil;
import org.apache.jackrabbit.oak.spi.security.authorization.cug.CugExclude;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;

@Component(service={CugExclude.class}, immediate=true)
@Designate(ocd=Configuration.class)
public class CugExcludeImpl
extends CugExclude.Default {
    private Set<String> principalNames = Collections.emptySet();

    @Override
    public boolean isExcluded(@NotNull Set<Principal> principals) {
        if (super.isExcluded(principals)) {
            return true;
        }
        if (!this.principalNames.isEmpty()) {
            for (Principal p : principals) {
                if (!this.principalNames.contains(p.getName())) continue;
                return true;
            }
        }
        return false;
    }

    @Activate
    protected void activate(Map<String, Object> properties) {
        this.setPrincipalNames(properties);
    }

    @Modified
    protected void modified(Map<String, Object> properties) {
        this.setPrincipalNames(properties);
    }

    private void setPrincipalNames(@NotNull Map<String, Object> properties) {
        this.principalNames = ImmutableSet.copyOf((Object[])PropertiesUtil.toStringArray((Object)properties.get("principalNames"), (String[])new String[0]));
    }

    @ObjectClassDefinition(name="Apache Jackrabbit Oak CUG Exclude List", description="Exclude principal(s) from CUG evaluation. In addition to the principals defined by the default CugExclude ('AdminPrincipal', 'SystemPrincipal', 'SystemUserPrincipal' classes), this component allows to optionally configure additional principals by name.")
    static @interface Configuration {
        @AttributeDefinition(name="Principal Names", description="Name(s) of additional principal(s) that are excluded from CUG evaluation.", cardinality=0x7FFFFFFF)
        public String[] principalNames() default {};
    }
}

