/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.authorization.cug.impl;

import java.util.Set;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.jetbrains.annotations.NotNull;

class SupportedPaths {
    private final String[] paths;
    private final String[] altPaths;
    private final boolean includesRootPath;

    SupportedPaths(@NotNull Set<String> supportedPaths) {
        this.paths = supportedPaths.toArray(new String[0]);
        this.altPaths = new String[supportedPaths.size()];
        boolean foundRootPath = false;
        int i = 0;
        for (String p : supportedPaths) {
            if (PathUtils.denotesRoot((String)p)) {
                foundRootPath = true;
                continue;
            }
            this.altPaths[i++] = p + '/';
        }
        this.includesRootPath = foundRootPath;
    }

    boolean includes(@NotNull String path) {
        if (this.paths.length == 0) {
            return false;
        }
        if (this.includesRootPath) {
            return true;
        }
        for (String p : this.altPaths) {
            if (!path.startsWith(p)) continue;
            return true;
        }
        for (String p : this.paths) {
            if (!path.equals(p)) continue;
            return true;
        }
        return false;
    }

    boolean mayContainCug(@NotNull String path) {
        if (this.paths.length == 0) {
            return false;
        }
        if (this.includesRootPath || PathUtils.denotesRoot((String)path)) {
            return true;
        }
        String path2 = path + '/';
        for (String sp : this.paths) {
            if (!sp.startsWith(path2)) continue;
            return true;
        }
        return false;
    }
}

