/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.authorization.cug.impl;

import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.plugins.tree.TreeType;
import org.apache.jackrabbit.oak.spi.security.authorization.cug.impl.AbstractTreePermission;
import org.apache.jackrabbit.oak.spi.security.authorization.cug.impl.CugConstants;
import org.apache.jackrabbit.oak.spi.security.authorization.cug.impl.CugPermissionProvider;
import org.apache.jackrabbit.oak.spi.security.authorization.cug.impl.CugUtil;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.TreePermission;

final class CugTreePermission
extends AbstractTreePermission
implements CugConstants {
    private final TreePermission parent;
    private Status status;

    CugTreePermission(@Nonnull Tree tree, @Nonnull TreeType type, @Nonnull TreePermission parent, @Nonnull CugPermissionProvider permissionProvider) {
        super(tree, type, permissionProvider);
        this.parent = parent;
    }

    CugTreePermission(@Nonnull Tree tree, @Nonnull TreeType type, @Nonnull TreePermission parent, @Nonnull CugPermissionProvider permissionProvider, boolean inCug, boolean canRead, boolean hasNestedCug) {
        super(tree, type, permissionProvider);
        this.parent = parent;
        this.status = new Status(inCug, canRead, hasNestedCug);
    }

    boolean isInCug() {
        if (this.status == null) {
            this.loadStatus();
        }
        return this.status.inCug;
    }

    boolean isAllow() {
        if (this.status == null) {
            this.loadStatus();
        }
        return this.status.allow;
    }

    boolean hasNestedCug() {
        if (this.status == null) {
            this.loadStatus();
        }
        return this.status.hasNested;
    }

    private Status getStatus() {
        if (this.status == null) {
            this.loadStatus();
        }
        return this.status;
    }

    private void loadStatus() {
        Tree cugTree;
        CugTreePermission parentCugPerm;
        CugTreePermission cugTreePermission = parentCugPerm = this.parent instanceof CugTreePermission ? (CugTreePermission)this.parent : null;
        this.status = CugTreePermission.neverNested(parentCugPerm) ? parentCugPerm.getStatus() : ((cugTree = CugUtil.getCug(this.tree)) != null ? new Status(true, this.permissionProvider.isAllow(cugTree), CugUtil.hasNestedCug(cugTree)) : (parentCugPerm != null ? parentCugPerm.getStatus() : Status.FALSE));
    }

    private static boolean neverNested(@CheckForNull CugTreePermission parentCugPerm) {
        if (parentCugPerm != null) {
            Status st = parentCugPerm.status;
            return st != null && st.inCug && !st.hasNested;
        }
        return false;
    }

    public boolean canRead() {
        return this.isAllow();
    }

    public boolean canRead(@Nonnull PropertyState property) {
        return this.isAllow();
    }

    public boolean canReadAll() {
        return false;
    }

    public boolean canReadProperties() {
        return this.isAllow();
    }

    public boolean isGranted(long permissions) {
        return permissions == 1L && this.isAllow();
    }

    public boolean isGranted(long permissions, @Nonnull PropertyState property) {
        return permissions == 2L && this.isAllow();
    }

    private static final class Status {
        private static final Status FALSE = new Status(false, false, false);
        private final boolean inCug;
        private final boolean allow;
        private final boolean hasNested;

        private Status(boolean inCug, boolean allow, boolean hasNested) {
            this.inCug = inCug;
            this.allow = allow;
            this.hasNested = hasNested;
        }
    }
}

