/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.authorization.cug.impl;

import com.google.common.collect.ImmutableSet;
import java.security.Principal;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Modified;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.jackrabbit.oak.commons.PropertiesUtil;
import org.apache.jackrabbit.oak.spi.security.authorization.cug.CugExclude;

@Component(metatype=true, label="Apache Jackrabbit Oak CUG Exclude List", description="Allows to exclude principal(s) with the configured name(s) from CUG evaluation.", policy=ConfigurationPolicy.REQUIRE)
@Service(value={CugExclude.class})
@Properties(value={@Property(name="principalNames", label="Principal Names", description="Name of principals that are always excluded from CUG evaluation.", cardinality=0x7FFFFFFF)})
public class CugExcludeImpl
extends CugExclude.Default {
    private Set<String> principalNames = Collections.emptySet();

    @Override
    public boolean isExcluded(@Nonnull Set<Principal> principals) {
        if (super.isExcluded(principals)) {
            return true;
        }
        if (!this.principalNames.isEmpty()) {
            for (Principal p : principals) {
                if (!this.principalNames.contains(p.getName())) continue;
                return true;
            }
        }
        return false;
    }

    @Activate
    protected void activate(Map<String, Object> properties) {
        this.setPrincipalNames(properties);
    }

    @Modified
    protected void modified(Map<String, Object> properties) {
        this.setPrincipalNames(properties);
    }

    private void setPrincipalNames(@Nonnull Map<String, Object> properties) {
        this.principalNames = ImmutableSet.copyOf((Object[])PropertiesUtil.toStringArray((Object)properties.get("principalNames"), (String[])new String[0]));
    }
}

