/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.authorization.cug.impl;

import java.io.IOException;
import java.io.InputStream;
import java.security.Principal;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.RepositoryException;
import javax.jcr.security.AccessControlManager;
import org.apache.jackrabbit.guava.common.collect.ImmutableList;
import org.apache.jackrabbit.guava.common.collect.ImmutableSet;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.plugins.memory.MemoryNodeStore;
import org.apache.jackrabbit.oak.plugins.nodetype.ReadOnlyNodeTypeManager;
import org.apache.jackrabbit.oak.plugins.nodetype.write.NodeTypeRegistry;
import org.apache.jackrabbit.oak.spi.commit.CommitHook;
import org.apache.jackrabbit.oak.spi.commit.MoveTracker;
import org.apache.jackrabbit.oak.spi.commit.ValidatorProvider;
import org.apache.jackrabbit.oak.spi.lifecycle.RepositoryInitializer;
import org.apache.jackrabbit.oak.spi.mount.MountInfoProvider;
import org.apache.jackrabbit.oak.spi.mount.Mounts;
import org.apache.jackrabbit.oak.spi.security.ConfigurationBase;
import org.apache.jackrabbit.oak.spi.security.ConfigurationParameters;
import org.apache.jackrabbit.oak.spi.security.Context;
import org.apache.jackrabbit.oak.spi.security.SecurityConfiguration;
import org.apache.jackrabbit.oak.spi.security.SecurityProvider;
import org.apache.jackrabbit.oak.spi.security.authorization.AuthorizationConfiguration;
import org.apache.jackrabbit.oak.spi.security.authorization.cug.CugExclude;
import org.apache.jackrabbit.oak.spi.security.authorization.cug.impl.CugAccessControlManager;
import org.apache.jackrabbit.oak.spi.security.authorization.cug.impl.CugConstants;
import org.apache.jackrabbit.oak.spi.security.authorization.cug.impl.CugContext;
import org.apache.jackrabbit.oak.spi.security.authorization.cug.impl.CugImporter;
import org.apache.jackrabbit.oak.spi.security.authorization.cug.impl.CugPermissionProvider;
import org.apache.jackrabbit.oak.spi.security.authorization.cug.impl.CugUtil;
import org.apache.jackrabbit.oak.spi.security.authorization.cug.impl.CugValidatorProvider;
import org.apache.jackrabbit.oak.spi.security.authorization.cug.impl.NestedCugHook;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.EmptyPermissionProvider;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.PermissionProvider;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.RestrictionProvider;
import org.apache.jackrabbit.oak.spi.state.ApplyDiff;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStateDiff;
import org.apache.jackrabbit.oak.spi.state.NodeStore;
import org.apache.jackrabbit.oak.spi.xml.ProtectedItemImporter;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;

@Component(service={AuthorizationConfiguration.class, SecurityConfiguration.class}, property={"oak.security.name=org.apache.jackrabbit.oak.spi.security.authorization.cug.impl.CugConfiguration"}, configurationPolicy=ConfigurationPolicy.REQUIRE)
@Designate(ocd=Configuration.class)
public class CugConfiguration
extends ConfigurationBase
implements AuthorizationConfiguration,
CugConstants {
    private CugExclude exclude;
    private MountInfoProvider mountInfoProvider = Mounts.defaultMountInfoProvider();
    private Set<String> supportedPaths = ImmutableSet.of();

    public CugConfiguration() {
    }

    public CugConfiguration(@NotNull SecurityProvider securityProvider) {
        super(securityProvider, securityProvider.getParameters("org.apache.jackrabbit.oak.authorization"));
    }

    @NotNull
    public AccessControlManager getAccessControlManager(@NotNull Root root, @NotNull NamePathMapper namePathMapper) {
        return new CugAccessControlManager(root, namePathMapper, this.getSecurityProvider(), this.supportedPaths, this.getExclude(), this.getRootProvider());
    }

    @NotNull
    public RestrictionProvider getRestrictionProvider() {
        return RestrictionProvider.EMPTY;
    }

    @NotNull
    public PermissionProvider getPermissionProvider(@NotNull Root root, @NotNull String workspaceName, @NotNull Set<Principal> principals) {
        ConfigurationParameters params = this.getParameters();
        boolean enabled = (Boolean)params.getConfigValue("cugEnabled", (Object)false);
        if (!enabled || this.supportedPaths.isEmpty() || this.getExclude().isExcluded(principals)) {
            return EmptyPermissionProvider.getInstance();
        }
        return new CugPermissionProvider(root, workspaceName, principals, this.supportedPaths, ((AuthorizationConfiguration)this.getSecurityProvider().getConfiguration(AuthorizationConfiguration.class)).getContext(), this.getRootProvider(), this.getTreeProvider());
    }

    @NotNull
    public String getName() {
        return "org.apache.jackrabbit.oak.authorization";
    }

    @NotNull
    public RepositoryInitializer getRepositoryInitializer() {
        return builder -> {
            NodeState base = builder.getNodeState();
            MemoryNodeStore store = new MemoryNodeStore(base);
            Root root = this.getRootProvider().createSystemRoot((NodeStore)store, null);
            if (CugConfiguration.registerCugNodeTypes(root)) {
                NodeState target = store.getRoot();
                target.compareAgainstBaseState(base, (NodeStateDiff)new ApplyDiff(builder));
            }
        };
    }

    @NotNull
    public List<? extends CommitHook> getCommitHooks(@NotNull String workspaceName) {
        return Collections.singletonList(new NestedCugHook());
    }

    @NotNull
    public List<? extends ValidatorProvider> getValidators(@NotNull String workspaceName, @NotNull Set<Principal> principals, @NotNull MoveTracker moveTracker) {
        return ImmutableList.of((Object)new CugValidatorProvider());
    }

    @NotNull
    public List<ProtectedItemImporter> getProtectedItemImporters() {
        return Collections.singletonList(new CugImporter(this.mountInfoProvider));
    }

    @NotNull
    public Context getContext() {
        return CugContext.INSTANCE;
    }

    public void setParameters(@NotNull ConfigurationParameters config) {
        super.setParameters(config);
        this.supportedPaths = CugUtil.getSupportedPaths(config, this.mountInfoProvider);
    }

    @Activate
    protected void activate(Map<String, Object> properties) {
        this.setParameters(ConfigurationParameters.of(properties));
    }

    @Modified
    protected void modified(Map<String, Object> properties) {
        this.activate(properties);
    }

    @Reference(name="mountInfoProvider")
    public void bindMountInfoProvider(MountInfoProvider mountInfoProvider) {
        this.mountInfoProvider = mountInfoProvider;
    }

    public void unbindMountInfoProvider(MountInfoProvider mountInfoProvider) {
        this.mountInfoProvider = null;
    }

    @Reference(name="exclude", cardinality=ReferenceCardinality.MANDATORY)
    public void bindExclude(CugExclude exclude) {
        this.exclude = exclude;
    }

    public void unbindExclude(CugExclude exclude) {
        this.exclude = null;
    }

    @NotNull
    private CugExclude getExclude() {
        return this.exclude == null ? new CugExclude.Default() : this.exclude;
    }

    static boolean registerCugNodeTypes(final @NotNull Root root) {
        block8: {
            boolean bl;
            block9: {
                ReadOnlyNodeTypeManager ntMgr = new ReadOnlyNodeTypeManager(){

                    @NotNull
                    protected Tree getTypes() {
                        return root.getTree("/jcr:system/jcr:nodeTypes");
                    }
                };
                if (ntMgr.hasNodeType("rep:CugPolicy")) break block8;
                InputStream stream = CugConfiguration.class.getResourceAsStream("cug_nodetypes.cnd");
                try {
                    NodeTypeRegistry.register((Root)root, (InputStream)stream, (String)"cug node types");
                    bl = true;
                    if (stream == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException | RepositoryException e) {
                        throw new IllegalStateException("Unable to read cug node types", e);
                    }
                }
                stream.close();
            }
            return bl;
        }
        return false;
    }

    @ObjectClassDefinition(name="Apache Jackrabbit Oak CUG Configuration", description="Authorization configuration dedicated to setup and evaluate 'Closed User Group' permissions.")
    static @interface Configuration {
        @AttributeDefinition(name="Supported Paths", description="Paths under which CUGs can be created and will be evaluated.", cardinality=0x7FFFFFFF)
        public String[] cugSupportedPaths() default {};

        @AttributeDefinition(name="CUG Evaluation Enabled", description="Flag to enable the evaluation of the configured CUG policies.")
        public boolean cugEnabled() default false;

        @AttributeDefinition(name="Ranking", description="Ranking of this configuration in a setup with multiple authorization configurations.")
        public int configurationRanking() default 200;
    }
}

